% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSUBFAT2DBC_function.R
\name{PSUBFAT2DBC}
\alias{PSUBFAT2DBC}
\title{Analysis: Plot subdivided into randomized blocks with a subplot in a double factorial scheme}
\usage{
PSUBFAT2DBC(
  f1,
  f2,
  f3,
  block,
  resp,
  alpha.f = 0.05,
  alpha.t = 0.05,
  norm = "sw",
  homog = "bt",
  mcomp = "tukey"
)
}
\arguments{
\item{f1}{Numeric or complex vector with plot levels}

\item{f2}{Numeric or complex vector with splitplot levels}

\item{f3}{Numeric or complex vector with splitsplitplot levels}

\item{block}{Numeric or complex vector with blocks}

\item{resp}{Numeric vector with responses}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}

\item{norm}{Error normality test (\emph{default} is Shapiro-Wilk)}

\item{homog}{Homogeneity test of variances (\emph{default} is Bartlett)}

\item{mcomp}{Multiple comparison test (Tukey (\emph{default}), LSD and Duncan)}
}
\value{
Analysis of variance of fixed effects and multiple comparison test of Tukey, Scott-Knott, LSD or Duncan.
}
\description{
This function performs the analysis of a randomized block design in a split-plot with a subplot in a double factorial scheme.
}
\examples{
f1=rep(c("PD","PDE","C"), e = 40);f1=factor(f1,unique(f1))
f2=rep(c(300,400), e = 20,3);f2=factor(f2,unique(f2))
f3=rep(c("c1", "c2", "c3", "c4"), e = 5,6);f3=factor(f3,unique(f3))
bloco=rep(paste("B",1:5),24); bloco=factor(bloco,unique(bloco))
set.seed(10)
resp=rnorm(120,50,5)
PSUBFAT2DBC(f1,f2,f3,bloco,resp,alpha.f = 0.5) # force triple interaction
PSUBFAT2DBC(f1,f2,f3,bloco,resp,alpha.f = 0.4) # force double interaction
}
