% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{[.AmigaBasic}
\alias{[.AmigaBasic}
\alias{[<-.AmigaBasic}
\alias{`[[.AmigaBasic`}
\alias{[[.AmigaBasic}
\alias{`[[<-.AmigaBasic`}
\alias{[[<-.AmigaBasic}
\title{Extract or replace lines of Amiga Basic code}
\usage{
\method{[}{AmigaBasic}(x, i)

\method{[}{AmigaBasic}(x, i) <- value

\method{[[}{AmigaBasic}(x, i)

\method{[[}{AmigaBasic}(x, i) <- value
}
\arguments{
\item{x}{An \code{AmigaBasic} class object from which specific lines
need to be extracted or replaced.}

\item{i}{In case of \verb{[[', an integer index, representing the line-number of basic code to be selected. In case of }[': a \code{vector} of \code{numeric} indices. This index
is used to select specific lines. Negative values will deselect lines.}

\item{value}{A \code{vector} of \code{character} strings or an
\code{\link[=AmigaBasic]{AmigaBasic()}} class object that is used to replace
the selected indices \code{i}. \code{value} should represent the
same number of lines of code as the selected number of lines.}
}
\value{
The extraction method returns an \code{\link[=AmigaBasic]{AmigaBasic()}} object based in the lines selected with \code{i}.
The replacement method returns an \code{\link[=AmigaBasic]{AmigaBasic()}} object with the selected lines replaced with \code{value}.
}
\description{
Extract or replace lines of Amiga Basic code
}
\details{
Extract or replace specific lines in an \code{\link[=AmigaBasic]{AmigaBasic()}}-class object.
}
\examples{
## First generate a few lines of Basic code:
bas <- as.AmigaBasic(c(
  "LET a = 1",
  "a = a + 1",
  "PRINT \"a now equals\";a",
  "INPUT \"clear screen (y/n)? \", b$",
  "IF UCASE$(b$) = \"Y\" THEN CLS"
))

## Select only lines 4 and 5:
bas[4:5]

## use negative indices to deselect specific lines.
## deselect line 2:
bas[-2]

## replace line 2
bas[2] <- "a = a + 2"

## You can also use AmigaBasic class object as replacement
bas[2] <- as.AmigaBasic("a = a + 3")

## single lines can also be selected with '[['
bas[[2]]
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{AmigaBasic}},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.character}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()},
\code{\link{write.AmigaBasic}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
