% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brvm_get1.R
\name{BRVM_get1}
\alias{BRVM_get1}
\title{BRVM Get - Get BRVM stock exchange Ticker Data}
\usage{
BRVM_get1(ticker = "BICC", Period = 0, from = Sys.Date() - 89, to = Sys.Date())
}
\arguments{
\item{ticker}{A vector of ticker, like: c("BICC","XOM","SlbC", "BRvm10")}

\item{Period}{Numeric number indicating time period. Valid entries are 0, 1, 5, 30, 91, and 365 representing respectively 'daily', 'one year', 'weekly', 'monthly', 'quarterly' and 'yearly'.}

\item{from}{A quoted start date, ie. "2020-01-01" or "2020/01/01". The date
must be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD".}

\item{to}{A quoted end date, ie. "2022-01-31" or "2022/01/31". The date must
be in ymd format "YYYY-MM-DD" or "YYYY/MM/DD"}
}
\value{
A tibble
}
\description{
This function will get data from the Sikafinance exchange.
}
\details{
This function will get data of the companies listed on the BVRM exchange through the sikafinance site. The function
takes in a single parameter of \code{ticker} The function will auto-format the
tickers you input into all upper case by using \code{toupper()}
}
\examples{
\donttest{
library(lubridate)
library(rlang)
library(httr2)
library(dplyr)
library(stringr)

symbols <- c("BiCc","XOM","SlbC")
data_tbl <- BRVM_get1(ticker = symbols)
data_tbl

#From three year ago to the present

BRVM_get1("ALL INDEXES", from = Sys.Date() - 252*3, to = Sys.Date())

BRVM_get1(ticker = "BRVMAG", from = "2010-01-04", to = "2022-01-04")

BRVM_get1("ALL", Period = 0, from = "2010-01-04", to = "2022-01-04"  ) #To get daily data

BRVM_get1("BrvmAS", Period = 1 ) # To get daily data for a whole year

BRVM_get1(c("BRVMPR", "BRVMAG"), Period = 5) # To get weekly data

BRVM_get1("BRVMAG", Period = 30 ) # To get monthly data

BRVM_get1("BRVMPR", Period = 91 ) # To get quaterly data

BRVM_get1(c("brvmtr", "BiCc", "BOAS"), Period = 365 ) # To get yearly data
}

}
\seealso{
\url{https://www.sikafinance.com/}

\code{BRVM_ticker_desc()}, \code{BRVM_tickers()}, \code{BRVM_get()}, \code{BRVM_index_stock()}

Other Data Retrieval: 
\code{\link{BRVM_bySector}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_get}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_nbrank}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()}
}
\author{
Koffi Frederic SESSIE
}
\concept{Data Retrieval}
\concept{Sikafinance}
