% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes_Ord_Design_Switch.R
\name{ss_switch}
\alias{ss_switch}
\title{Determine the sample size for Bayesian two-stage trial design for
ordinal endpoints based on switch model}
\usage{
ss_switch(
  alpha,
  power,
  n_po,
  n_npo,
  or_alt,
  pro_ctr,
  U,
  ntrial,
  method,
  n_range
)
}
\arguments{
\item{alpha}{the desirable type I error rate to be controlled}

\item{power}{the desirable power to be achieved}

\item{n_po}{sample size for the treatment and control groups, at each stage
based on PO model}

\item{n_npo}{sample size for the treatment and control groups, at each stage
based on NPO model}

\item{or_alt}{expected treatment efficacy effect size to be
detected (under H_1) in terms of odds ratio}

\item{pro_ctr}{distribution of clinical categories for the
control group}

\item{U}{the desirability of each outcome level}

\item{ntrial}{the number of simulated trials}

\item{method}{whether the statistical test for interim/final analysis is Bayesian or
Frequentist. method = "Frequentist" for Frequentist approach; method = "Bayesian"
for Bayesian approach}

\item{n_range}{the additional sample size for each arm each stage after n_po, n_npo.}
}
\value{
ss_switch() returns recommended sample size for each group at every
interim look, with assumption that the sample size in the control arm of the
study is same as in the treatment arm, and the sample size at each interim
look is same.
}
\description{
When there lacks of sufficient information to determine which of these two
models (PO or NPO) is more appropriate, PO/NPO switch model-based design is
utilized to obtain estimated sample size based on user specified type I
error, power and expected effect.
}
\details{
Grid search of sample size is used for guarantee a desirable type I error rate.
  The upper limitation is 200, and lower limitation default is sample size 50
  for the control and treatment groups at each stage. Default increment of the
  sequence is 10.

  For the parameter estimation section, we have two options, and can be selected using
  the method argument.Two following options are available: (i) method = "Frequentist",
  (ii) method = "Bayesian". If method = "Frequentist", parameters are estimated via package
  ordinal, which is based on frequentist method, while method = "Bayesian", parameters are
  estimated through Bayesian model.

  Specifically, the numerical utilities U reflect the desirability of each outcome
  level. To do this, in our example, we first set U[1] = 100 and U[5] = 0, and then
  asked physicians to specify numerical values for the intermediate levels, that
  reflect their desirability relative to the best and worst levels.

  Arguments n_po and n_npo are the estimated sample size for the treatment and
  control groups at each stage based on PO model and NPO model respectively. Users can
  obtained them through function ss_po and ss_npo.
}
\examples{
\donttest{
ss_switch(alpha = 0.05, power=0.8, n_po = 475, n_npo = 75, n_range = 10,
          or_alt = c(1.5,1.5,1.5,1.5,1.5), pro_ctr = c(0.58,0.05,0.17,0.03,0.04,0.13),
          U = c(100,80,65,25,10,0), ntrial = 5, method = "Frequentist")
         }

}
