/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.CodonTable;

public final class GeneticCode
implements CodonTable {
    public static final String GENETIC_CODE = "geneticCode";
    public static final int UNIVERSAL_ID = 0;
    public static final int VERTEBRATE_MT_ID = 1;
    public static final int YEAST_ID = 2;
    public static final int MOLD_PROTOZOAN_MT_ID = 3;
    public static final int MYCOPLASMA_ID = 4;
    public static final int INVERTEBRATE_MT_ID = 5;
    public static final int CILIATE_ID = 6;
    public static final int ECHINODERM_MT_ID = 7;
    public static final int EUPLOTID_NUC_ID = 8;
    public static final int BACTERIAL_ID = 9;
    public static final int ALT_YEAST_ID = 10;
    public static final int ASCIDIAN_MT_ID = 11;
    public static final int FLATWORM_MT_ID = 12;
    public static final int BLEPHARISMA_NUC_ID = 13;
    public static final int NO_STOPS_ID = 14;
    public static final String[] GENETIC_CODE_TABLES = new String[]{"KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSS*CWCLFLF", "KNKNTTTT*S*SMIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", "KNKNTTTTRSRSMIMIQHQHPPPPRRRRTTTTEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", "KNKNTTTTSSSSMIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVVQYQYSSSS*CWCLFLF", "NNKNTTTTSSSSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSCCWCLFLF", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSS*CWCLFLF", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLSLEDEDAAAAGGGGVVVV*Y*YSSSS*CWCLFLF", "KNKNTTTTGSGSMIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*Y*YSSSSWCWCLFLF", "NNKNTTTTSSSSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVVYY*YSSSSWCWCLFLF", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVV*YQYSSSS*CWCLFLF", "KNKNTTTTRSRSIIMIQHQHPPPPRRRRLLLLEDEDAAAAGGGGVVVVYYQYSSSSWCWCLFLF"};
    public static final String[] GENETIC_CODE_NAMES = new String[]{"universal", "vertebrateMitochondrial", "yeast", "moldProtozoanMitochondrial", "mycoplasma", "invertebrateMitochondrial", "ciliate", "echinodermMitochondrial", "euplotidNuclear", "bacterial", "alternativeYeast", "ascidianMitochondrial", "flatwormMitochondrial", "blepharismaNuclear", "noStops"};
    public static final String[] GENETIC_CODE_DESCRIPTIONS = new String[]{"Universal", "Vertebrate Mitochondrial", "Yeast", "Mold Protozoan Mitochondrial", "Mycoplasma", "Invertebrate Mitochondrial", "Ciliate", "Echinoderm Mitochondrial", "Euplotid Nuclear", "Bacterial", "Alternative Yeast", "Ascidian Mitochondrial", "Flatworm Mitochondrial", "Blepharisma Nuclear", "Test case with no stop codons"};
    public static final GeneticCode UNIVERSAL = new GeneticCode(0);
    public static final GeneticCode VERTEBRATE_MT = new GeneticCode(1);
    public static final GeneticCode YEAST = new GeneticCode(2);
    public static final GeneticCode MOLD_PROTOZOAN_MT = new GeneticCode(3);
    public static final GeneticCode MYCOPLASMA = new GeneticCode(4);
    public static final GeneticCode INVERTEBRATE_MT = new GeneticCode(5);
    public static final GeneticCode CILIATE = new GeneticCode(6);
    public static final GeneticCode ECHINODERM_MT = new GeneticCode(7);
    public static final GeneticCode EUPLOTID_NUC = new GeneticCode(8);
    public static final GeneticCode BACTERIAL = new GeneticCode(9);
    public static final GeneticCode ALT_YEAST = new GeneticCode(10);
    public static final GeneticCode ASCIDIAN_MT = new GeneticCode(11);
    public static final GeneticCode FLATWORM_MT = new GeneticCode(12);
    public static final GeneticCode BLEPHARISMA_NUC = new GeneticCode(13);
    public static final GeneticCode NO_STOPS = new GeneticCode(14);
    public static final GeneticCode[] GENETIC_CODES = new GeneticCode[]{UNIVERSAL, VERTEBRATE_MT, YEAST, MOLD_PROTOZOAN_MT, MYCOPLASMA, INVERTEBRATE_MT, CILIATE, ECHINODERM_MT, EUPLOTID_NUC, BACTERIAL, ALT_YEAST, ASCIDIAN_MT, FLATWORM_MT, BLEPHARISMA_NUC, NO_STOPS};
    private int geneticCode;
    private String codeTable;

    public GeneticCode(int n) {
        this.geneticCode = n;
        this.codeTable = GENETIC_CODE_TABLES[n];
    }

    public String getName() {
        return GENETIC_CODE_NAMES[this.geneticCode];
    }

    public String getDescription() {
        return GENETIC_CODE_DESCRIPTIONS[this.geneticCode];
    }

    @Override
    public char getAminoAcidChar(int n) {
        if (n == 64) {
            return '?';
        }
        if (n == 65) {
            return '-';
        }
        return this.codeTable.charAt(n);
    }

    @Override
    public int getAminoAcidState(int n) {
        if (n == 64) {
            return 24;
        }
        if (n == 65) {
            return 25;
        }
        return AminoAcids.AMINOACID_STATES[this.getAminoAcidChar(n)];
    }

    public boolean isStopCodon(int n) {
        return this.getAminoAcidState(n) == 23;
    }

    @Override
    public char[][] getCodonsFromAminoAcidState(int n) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public char[][] getCodonsFromAminoAcidChar(char c) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public int[] getAmbiguousCodonFromAminoAcidState(int n) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public int[] getStopCodonIndices() {
        int n = this.getStopCodonCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.codeTable.charAt(i) != '*') continue;
            nArray[n2] = i;
            ++n2;
        }
        return nArray;
    }

    @Override
    public int getStopCodonCount() {
        int n = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.codeTable.charAt(i) != '*') continue;
            ++n;
        }
        return n;
    }
}

