/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.MutableTreeModel;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitDataModel;
import dr.evomodel.treedatalikelihood.preorder.AbstractRealizedContinuousTraitDelegate;
import dr.math.distributions.MultivariateNormalDistribution;

public class UnconditionalOnTipsDelegate
extends AbstractRealizedContinuousTraitDelegate {
    private final ConjugateRootTraitPrior rootPrior;

    public UnconditionalOnTipsDelegate(String string, MutableTreeModel mutableTreeModel, MultivariateDiffusionModel multivariateDiffusionModel, ContinuousTraitDataModel continuousTraitDataModel, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super(string, mutableTreeModel, multivariateDiffusionModel, continuousTraitDataModel, conjugateRootTraitPrior, continuousRateTransformation, continuousDataLikelihoodDelegate);
        this.rootPrior = conjugateRootTraitPrior;
    }

    @Override
    protected void simulateRoot(int n) {
        double[] dArray = this.rootPrior.getMean();
        double d = Math.sqrt(1.0 / this.rootPrior.getPseudoObservations());
        int n2 = this.dimNode * n;
        for (int i = 0; i < this.numTraits; ++i) {
            MultivariateNormalDistribution.nextMultivariateNormalCholesky(dArray, 0, this.cholesky, d, this.sample, n2, this.tmpEpsilon);
            n2 += this.dimTrait;
        }
    }

    protected void simulateNode(ProcessOnTreeDelegate.BranchNodeOperation branchNodeOperation, double d) {
        int n = branchNodeOperation.getNodeNumber();
        int n2 = this.dimNode * n;
        int n3 = this.dimNode * branchNodeOperation.getParentNumber();
        double d2 = branchNodeOperation.getBranchLength() * d;
        if (d2 == 0.0) {
            System.arraycopy(this.sample, n3, this.sample, n2, this.dimTrait * this.numTraits);
        } else {
            double d3 = Math.sqrt(d2);
            for (int i = 0; i < this.numTraits; ++i) {
                MultivariateNormalDistribution.nextMultivariateNormalCholesky(this.sample, n3, this.cholesky, d3, this.sample, n2, this.tmpEpsilon);
                n3 += this.dimTrait;
                n2 += this.dimTrait;
            }
        }
    }

    @Override
    protected void simulateNode(int n, int n2, int n3, int n4, int n5) {
        throw new RuntimeException("Not yet implemented -- see above");
    }
}

