/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterationReporter;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;
import no.uib.cipr.matrix.sparse.NoIterationReporter;

public abstract class AbstractIterationMonitor
implements IterationMonitor {
    protected int iter;
    protected Vector.Norm normType = Vector.Norm.Two;
    protected IterationReporter reporter = new NoIterationReporter();
    protected double residual;

    public void setFirst() {
        this.iter = 0;
    }

    public boolean isFirst() {
        return this.iter == 0;
    }

    public void next() {
        ++this.iter;
    }

    public int iterations() {
        return this.iter;
    }

    public boolean converged(Vector r, Vector x) throws IterativeSolverNotConvergedException {
        return this.converged(r.norm(this.normType), x);
    }

    public boolean converged(double r, Vector x) throws IterativeSolverNotConvergedException {
        this.reporter.monitor(r, x, this.iter);
        this.residual = r;
        return this.convergedI(r, x);
    }

    public boolean converged(double r) throws IterativeSolverNotConvergedException {
        this.reporter.monitor(r, this.iter);
        this.residual = r;
        return this.convergedI(r);
    }

    protected abstract boolean convergedI(double var1, Vector var3) throws IterativeSolverNotConvergedException;

    protected abstract boolean convergedI(double var1) throws IterativeSolverNotConvergedException;

    public boolean converged(Vector r) throws IterativeSolverNotConvergedException {
        return this.converged(r.norm(this.normType));
    }

    public Vector.Norm getNormType() {
        return this.normType;
    }

    public void setNormType(Vector.Norm normType) {
        this.normType = normType;
    }

    public IterationReporter getIterationReporter() {
        return this.reporter;
    }

    public void setIterationReporter(IterationReporter monitor) {
        this.reporter = monitor;
    }

    public double residual() {
        return this.residual;
    }
}

