% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{wrapper_xgboost}
\alias{wrapper_xgboost}
\title{Extreme Gradient Boosting wrapper for CCI}
\usage{
wrapper_xgboost(
  formula,
  data,
  train_indices,
  test_indices,
  metric,
  nrounds = 500,
  metricfunc = NULL,
  nthread = 1,
  num_class = NULL,
  subsample = 1,
  ...
)
}
\arguments{
\item{formula}{Model formula}

\item{data}{Data frame}

\item{train_indices}{Indices for training data}

\item{test_indices}{Indices for training data}

\item{metric}{Type of performance metric}

\item{nrounds}{Number of boosting rounds}

\item{metricfunc}{A user specific metric function which have the arguments data, model test_indices and test_matrix and returns a numeric value}

\item{nthread}{Integer. Number of threads to use for parallel computation during model training in XGBoost. Default is 1.}

\item{num_class}{Number of categorical classes}

\item{subsample}{Proportion of the data to be used. Default is 1 (no subsampling).}

\item{...}{Additional arguments passed to xgb.train}
}
\value{
Performance metric
}
\description{
Extreme Gradient Boosting wrapper for CCI
}
