% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLdeparture.R
\name{GLdeparture}
\alias{GLdeparture}
\alias{print.GLdeparture}
\alias{show.GLdeparture}
\alias{GLdeparture,Raster,Raster-method}
\alias{GLdeparture,Raster,missing-method}
\title{Climatic departure of reference study area}
\usage{
GLdeparture(
  x,
  y,
  center = TRUE,
  scale = TRUE,
  filename = "",
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE,
  ...
)

\S4method{GLdeparture}{Raster,Raster}(
  x,
  y,
  center = TRUE,
  scale = TRUE,
  filename = "",
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE,
  ...
)

\S4method{GLdeparture}{Raster,missing}(
  x,
  y,
  center = TRUE,
  scale = TRUE,
  filename = "",
  progress = FALSE,
  parallel = FALSE,
  n = 1,
  cl = NULL,
  keep.open = FALSE,
  ...
)
}
\arguments{
\item{x}{Raster* object of p historical climate layers}

\item{y}{Raster* object of p future climate layers, with the same names as
\code{x}}

\item{center}{logical or numeric. If \code{TRUE}, centering is done by
subtracting the layer means (omitting NAs), and if \code{FALSE}, no centering
is done. If \code{center} is a numeric vector with length equal to the
\code{nlayers(x)}, then each layer of \code{x} has the corresponding value
from center subtracted from it}

\item{scale}{logical or numeric. If \code{TRUE}, scaling is done by dividing
the (centered) layers of \code{x} by their standard deviations if center is
\code{TRUE}, and the root mean square otherwise. If scale is \code{FALSE},
no scaling is done. If scale is a numeric vector with length equal to
\code{nlayers(x)}, each layer of \code{x} is divided by the corresponding
value. Scaling is done after centering}

\item{filename}{character. Optional filename to save the RasterBrick output
to file. If this is not provided, a temporary file will be created for large
\code{x}}

\item{progress}{logical. If \code{TRUE}, messages and progress bar will be
printed}

\item{parallel}{logical. If \code{TRUE} then multiple cores are utilized}

\item{n}{numeric. Number of CPU cores to utilize for parallel processing}

\item{cl}{optional cluster object}

\item{keep.open}{logical. If \code{TRUE} and \code{parallel = TRUE}, the
cluster object will not be closed after the function has finished}

\item{...}{Additional arguments for \code{\link[raster]{writeRaster}}}
}
\value{
Returns an S4 object of class \code{GLcenfa} with the following components:
\describe{
  \item{global_difras}{Raster* \code{x} of p layers, possibly centered and scaled}
  \item{cov}{Global p x p covariance matrix}
  }
}
\description{
This function is used to facilitate comparisons between species in the same
study area. It speeds up the computation of multiple departures by calculating
the global covariance matrix as a first step, which
can then be fed into the \code{\link{departure}} function as a first argument.
This saves the user from having to calculate the global covariance matrix for
each species, which can take quite a bit of time.
}
\details{
If there is too much correlation between the layers of \code{x}, the covariance
matrix will be singular, which will lead to later problems in computing the overall
departures of species. In this case, a warning will be issued, suggesting the
removal of correlated variables or a transformation of the data.
}
\examples{
gld <- GLdeparture(x = climdat.hist, y = climdat.fut)

}
\seealso{
\code{\link{departure}}
}
