% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{hdbscan.seurat}
\alias{hdbscan.seurat}
\title{Initial Clustering for Evaluating Integration}
\usage{
hdbscan.seurat(
  seu,
  batch.var = "Batch",
  reduction = "pca",
  dims = seq_len(15),
  minPts = 25
)
}
\arguments{
\item{seu}{A Seurat object containing integrated or batch-corrected data (e.g. PCA results).}

\item{batch.var}{Character string specifying the metadata column that contains batch information. 
Default is "Batch".}

\item{reduction}{Character string specifying the name of the dimension reduction to use (e.g. "PCA"). 
Default is "PCA".}

\item{dims}{Numeric vector indicating the dimensions to be used for initial clustering. Default is 1:15.}

\item{minPts}{Integer specifying the minimum number of points required to form a cluster. 
This value is passed to the \code{hdbscan} function. Default is 25.}
}
\value{
A Seurat object with two additional columns in its \code{meta.data}: 
\code{dbscan_cluster} and \code{initial_cluster}.
}
\description{
This function applies HDBSCAN, a density-based clustering algorithm, to the corrected dimension 
reduction of a Seurat object.
}
\seealso{
\code{\link{getIDEr}}, \code{\link{estimateProb}}
}
