% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_transformer_132kv.R
\name{pof_transformer_132kv}
\alias{pof_transformer_132kv}
\title{Current Probability of Failure for 132kv Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
pof_transformer_132kv(
  transformer_type = "132kV Transformer (GM)",
  year_of_manufacture,
  utilisation_pct = "Default",
  no_taps = "Default",
  placement = "Default",
  altitude_m = "Default",
  distance_from_coast_km = "Default",
  corrosion_category_index = "Default",
  age_tf,
  age_tc,
  partial_discharge_tf = "Default",
  partial_discharge_tc = "Default",
  temperature_reading = "Default",
  main_tank = "Default",
  coolers_radiator = "Default",
  bushings = "Default",
  kiosk = "Default",
  cable_boxes = "Default",
  external_tap = "Default",
  internal_tap = "Default",
  mechnism_cond = "Default",
  diverter_contacts = "Default",
  diverter_braids = "Default",
  moisture = "Default",
  acidity = "Default",
  bd_strength = "Default",
  hydrogen = "Default",
  methane = "Default",
  ethylene = "Default",
  ethane = "Default",
  acetylene = "Default",
  hydrogen_pre = "Default",
  methane_pre = "Default",
  ethylene_pre = "Default",
  ethane_pre = "Default",
  acetylene_pre = "Default",
  furfuraldehyde = "Default",
  reliability_factor = "Default"
)
}
\arguments{
\item{transformer_type}{String. A sting that refers to the specific
asset category. See See page 17, table 1 in CNAIM (2021).
Options:
\code{transformer_type =
c("132kV Transformer (GM)"}}

\item{year_of_manufacture}{Numeric. Normal expected life depends on the
year for manufacture, see page 107 table 20 in CNAIM (2021).}

\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{no_taps}{Numeric. Average number of daily taps (tapchanger).}

\item{placement}{String. Specify if the asset is located outdoor or indoor.
A setting of \code{"Outdoor"} means the asset is
located in an outside environment,
and a setting of \code{"Indoor"} means the asset is located in an
 indoor environment. A setting of \code{"Default"} will result
  in either an indoor or an outdoor environment setting that depends
  on the specification of \code{asset_type}. See page 110-113,
  table 26 in CNAIM (2021) for default environments.}

\item{altitude_m}{Numeric. Specify the altitude location for
the asset measured in meters from sea level.\code{altitude_m}
is used to derive the altitude factor. See page 111,
table 23 in CNAIM (2021). A setting of \code{"Default"}
will set the altitude factor to 1 independent of \code{asset_type}.}

\item{distance_from_coast_km}{Numeric. Specify the distance from the
coast measured in kilometers. \code{distance_from_coast_km} is used
to derive the distance from coast factor See page 110,
table 22 in CNAIM (2021). A setting of \code{"Default"} will set the
 distance from coast factor to 1 independent of \code{asset_type}.}

\item{corrosion_category_index}{Integer.
Specify the corrosion index category, 1-5.
\code{corrosion_category_index} is used to derive the corrosion
category factor. See page 111, table 24 in CNAIM (2021).
A setting of \code{"Default"} will set the corrosion category factor
to 1 independent of \code{asset_type}.}

\item{age_tf}{Numeric. The current age in years
of the transformer.}

\item{age_tc}{Numeric. The current age in years
of the tapchanger}

\item{partial_discharge_tf}{String. Indicating the
level of partial discharge in the transformer.
Options:
\code{partial_discharge_tf = c("Low", "Medium", "High (Not Confirmed)",
 "High (Confirmed)", "Default")}. See page 155, table 176 in CNAIM (2021).}

\item{partial_discharge_tc}{String. Indicating the
level of partial discharge in the tapchanger
Options:
\code{partial_discharge_tc = c("Low", "Medium", "High (Not Confirmed)",
 "High (Confirmed)", "Default")}. See page 156, table 178 in CNAIM (2021).}

\item{temperature_reading}{String. Indicating the criticality.
Options:
\code{temperature_reading = c("Normal", "Moderately High",
"Very High", "Default")}. See page 155, table 177 in CNAIM (2021).}

\item{main_tank}{String. Indicating the observed condition of the
main tank. Options:
\code{main_tank = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 134, table 93
in CNAIM (2021).}

\item{coolers_radiator}{String. Indicating the observed condition of the
coolers/radiators. Options:
\code{coolers_radiator = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 134, table 94
in CNAIM (2021).}

\item{bushings}{String. Indicating the observed condition of the
bushings. Options:
\code{bushings = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 135, table 95
in CNAIM (2021).}

\item{kiosk}{String. Indicating the observed condition of the
kiosk. Options:
\code{kiosk = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 135, table 96
in CNAIM (2021).}

\item{cable_boxes}{String. Indicating the observed condition of the
cable boxes. Options:
\code{cable_boxes = c("No Deterioration","Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 135, table 97
in CNAIM (2021).}

\item{external_tap}{String. Indicating the observed external condition of the
 tapchanger. Options:
\code{external_tap = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 136, table 98
in CNAIM (2021).}

\item{internal_tap}{String. Indicating the observed internal condition of the
 tapchanger. Options:
\code{internal_tap = c("Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 136, table 99
in CNAIM (2021).}

\item{mechnism_cond}{String. Indicating the observed condition of the
 drive mechnism. Options:
\code{mechnism_cond = c("No deterioration", "Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 136, table 100
in CNAIM (2021).}

\item{diverter_contacts}{String. Indicating the observed condition of the
selector and diverter contacts. Options:
\code{diverter_contacts = c("No deterioration", "Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 136, table 101
in CNAIM (2021).}

\item{diverter_braids}{String. Indicating the observed condition of the
selector and diverter braids. Options:
\code{diverter_braids = c("No deterioration", "Superficial/minor deterioration", "Some Deterioration",
"Substantial Deterioration", "Default")}. See page 136, table 102
in CNAIM (2021)}

\item{moisture}{Numeric. Refers to the moisture level in the
transformer oil. Moisture levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{acidity}{Numeric. Refers to the acidity level in the
transformer oil. Acidity levels are measured in  (mgKOH/g).
A setting of \code{"Default"} will result in the best possible result.}

\item{bd_strength}{Numeric. Refers to the breakdown strength.
Breakdown strength is measured in kV.
A setting of \code{"Default"} will result in the best possible result.}

\item{hydrogen}{Numeric. Refers to the hydrogen level in the
transformer oil. Hydrogen levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{methane}{Numeric. Refers to the methane level in the
transformer oil. Methane levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethylene}{Numeric. Refers to the ethylene level in the
transformer oil. Ethylene levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethane}{Numeric. Refers to the ethane level in the
transformer oil. Ethane levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{acetylene}{Numeric. Refers to the acetylene level in the
transformer oil. Acetylene levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{hydrogen_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{methane_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethylene_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{ethane_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{acetylene_pre}{Numeric. Previous results.
A setting of \code{"Default"} will result in the best possible result.}

\item{furfuraldehyde}{Numeric. Refers to the furfuraldehyde level in the
transformer oil. furfuraldehyde levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}
}
\value{
Numeric. Current probability of failure.
}
\description{
This function calculates the current
annual probability of failure for 132kv transformers.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 34 in CNAIM (2021).
}
\examples{
# Current probability of failure for a 132kV transformer
pof_transformer_132kv(transformer_type = "132kV Transformer (GM)",
year_of_manufacture = 1980,
utilisation_pct = "Default",
no_taps = "Default",
placement = "Default",
altitude_m = "Default",
distance_from_coast_km = "Default",
corrosion_category_index = "Default",
age_tf = 43,
age_tc = 43,
partial_discharge_tf = "Default",
partial_discharge_tc = "Default",
temperature_reading = "Default",
main_tank = "Default",
coolers_radiator = "Default",
bushings = "Default",
kiosk = "Default",
cable_boxes = "Default",
external_tap = "Default",
internal_tap = "Default",
mechnism_cond = "Default",
diverter_contacts = "Default",
diverter_braids = "Default",
moisture = "Default",
acidity = "Default",
bd_strength = "Default",
hydrogen = "Default",
methane = "Default",
ethylene = "Default",
ethane = "Default",
acetylene = "Default",
hydrogen_pre = "Default",
methane_pre = "Default",
ethylene_pre = "Default",
ethane_pre = "Default",
acetylene_pre = "Default",
furfuraldehyde = "Default",
reliability_factor = "Default")
}
