% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_cables_10kv_oil.R
\name{pof_cables_10kv_oil}
\alias{pof_cables_10kv_oil}
\title{Current Probability of Failure for 10kV UG Oil Non Preesurised Cables (Armed Paper Lead)}
\usage{
pof_cables_10kv_oil(
  utilisation_pct = "Default",
  operating_voltage_pct = "Default",
  sheath_test = "Default",
  partial_discharge = "Default",
  fault_hist = "Default",
  reliability_factor = "Default",
  age,
  k_value = 0.24,
  c_value = 1.087,
  normal_expected_life = 80
)
}
\arguments{
\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{operating_voltage_pct}{Numeric. The ratio in percent of
operating/design voltage.}

\item{sheath_test}{String. Only applied for non pressurised cables.
Indicating the state of the sheath. Options:
\code{sheath_test = c("Pass", "Failed Minor", "Failed Major",
"Default")}.}

\item{partial_discharge}{String. Only applied for non pressurised cables.
Indicating the level of partial discharge. Options:
\code{partial_discharge = c("Low", "Medium", "High",
 "Default")}.}

\item{fault_hist}{Numeric. Only applied for non pressurised cables.
The calculated fault rate for the cable in the period per kilometer.
A setting of \code{"No historic faults recorded"}
indicates no fault.}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}

\item{age}{Numeric. The current age in years of the cable.}

\item{k_value}{Numeric. \code{k_value = 0.24} by default.}

\item{c_value}{Numeric. \code{c_value = 1.087} by default.
The default value is accordingly to the CNAIM standard see page 110}

\item{normal_expected_life}{Numeric. \code{normal_expected_life = 80} by default.}
}
\value{
Numeric. Current probability of failure
per annum for 10 kV oil cables.
}
\description{
This function calculates the current
annual probability of failure per kilometer for a Oil non Preesurised cables.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function.
}
\examples{
# Current annual probability of failure for 10kV oil cable, 50 years old
}
