% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_cof_swg_tf_ohl.R
\name{s_cof_swg_tf_ohl}
\alias{s_cof_swg_tf_ohl}
\title{Safety Consequences of Failure for Switchgears, Transformers &
Overhead Lines}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
s_cof_swg_tf_ohl(
  type_risk = "Default",
  location_risk = "Default",
  asset_type_scf
)
}
\arguments{
\item{type_risk}{String. Risk that the asset presents to the
public by its characteristics and particular situation. Options:
\code{type_risk = c("Low", "Medium", "High", "Default")}
(cf. table 225, page 183, CNAIM, 2021).
A setting of \code{"Default"} equals a setting of \code{"Medium"}.}

\item{location_risk}{String. Proximity to areas that may affect its
likelihood of trespass or interference. Options:
\code{location_risk = c("Low", "Medium", "High", "Default")}
(cf. table 225, page 183, CNAIM, 2021).
A setting of \code{"Default"} equals a setting of \code{"Medium"}.}

\item{asset_type_scf}{String.
Options:
\code{asset_type_scf = c("LV Poles", "LV Circuit Breaker",
"LV Pillar (ID)", "LV Pillar (OD at Substation)",
"LV Pillar (OD not at a Substation)", "LV Board (WM)",
"LV UGB", "LV Board (X-type Network) (WM)", "6.6/11kV Poles",
"20kV Poles", "6.6/11kV CB (GM) Primary",
"6.6/11kV CB (GM) Secondary", "6.6/11kV Switch (GM)", "6.6/11kV RMU",
"6.6/11kV X-type RMU", "20kV CB (GM) Primary", "20kV CB (GM) Secondary",
"20kV Switch (GM)", "20kV RMU", "6.6/11kV Transformer (GM)",
"20kV Transformer (GM)", "33kV Pole", "66kV Pole",
"33kV OHL (Tower Line) Conductor", "33kV Tower", "33kV Fittings",
"66kV OHL (Tower Line) Conductor", "66kV Tower", "66kV Fittings",
"33kV CB (Air Insulated Busbars)(ID) (GM)",
"33kV CB (Air Insulated Busbars)(OD) (GM)",
"33kV CB (Gas Insulated Busbars)(ID) (GM)",
"33kV CB (Gas Insulated Busbars)(OD) (GM)", "33kV Switch (GM)",
"33kV RMU", "66kV CB (Air Insulated Busbars)(ID) (GM)",
"66kV CB (Air Insulated Busbars)(OD) (GM)",
"66kV CB (Gas Insulated Busbars)(ID) (GM)",
"66kV CB (Gas Insulated Busbars)(OD) (GM)", "33kV Transformer (GM)",
"66kV Transformer (GM)", "132kV OHL (Tower Line) Conductor",
"132kV Tower", "132kV Fittings",
"132kV CB (Air Insulated Busbars)(ID) (GM)",
"132kV CB (Air Insulated Busbars)(OD) (GM)",
"132kV CB (Gas Insulated Busbars)(ID) (GM)",
"132kV CB (Gas Insulated Busbars)(OD) (GM)", "132kV Transformer (GM)")
}}
}
\value{
Numeric. Safety consequences of failure for
switchgear, transformers and overhead lines.
}
\description{
This function calculates safety consequences of failure
for switchgear, transformers and overhead lines
(cf. section 7.4, page 80, CNAIM, 2021). Safety consequences of failure
is used in the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
# Safety consequences failure for a 6.6/11 kV transformer
s_cof_swg_tf_ohl(type_risk = "Default", location_risk = "Default",
                 asset_type_scf = "6.6/11kV Transformer (GM)")
}
