% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{decode.block}
\alias{decode.block}
\title{Decoding method using block iterated conditional modes algorithm}
\usage{
decode.block(crf, blocks, decode.method = decode.tree, restart = 0,
  start = apply(crf$node.pot, 1, which.max), ...)
}
\arguments{
\item{crf}{The CRF}

\item{blocks}{A list of vectors, each vector containing the nodes in a block}

\item{decode.method}{The decoding method to solve the clamped CRF}

\item{restart}{Non-negative integer to control how many restart iterations are repeated}

\item{start}{An initial configuration, a good start will significantly reduce the seraching time}

\item{...}{The parameters for \code{decode.method}}
}
\value{
This function will return the most likely configuration, which is a vector of length \code{crf$n.nodes}.
}
\description{
Computing the most likely configuration for CRF
}
\details{
Approximate decoding with the block iterated conditional modes algorithm
}
\examples{

library(CRF)
data(Small)
d <- decode.block(Small$crf, list(c(1,3), c(2,4)))

}

