\name{CBData}
\alias{CBData}
\title{Create a `CBdata' object from a data frame.}
\description{
The \code{CBData} function creates an object of class \dfn{CBData} that is
used in further analyses. It identifies the variables that define treatment
group, clustersize and the number of responses. 
}
\usage{
CBData(x, trt, clustersize, nresp, freq = NULL)
}
\arguments{
  \item{x}{a data frame with one row representing a cluster or potentially a set of clusters
  of the same size and number of responses}
  \item{trt}{the name of the variable that defines treatment group}
  \item{clustersize}{the name of the variable that defines cluster size}
  \item{nresp}{the name of the variable that defines the number of responses in the cluster}
  \item{freq}{the name of the variable that defines the number of clusters represented
  by the data row. If \code{NULL}, then each row is assumed to correspond to one cluster.}
}
\value{
  A data frame with each row representing all the clusters with the same trt/size/number of responses,
  and standardized variable names:
  \item{Trt}{factor, the treatment group}
  \item{ClusterSize}{numeric, the cluster size}
  \item{NResp}{numeric, the number of responses}
  \item{Freq}{numeric, number of clusters with the same values}
}
\author{Aniko Szabo}

\seealso{\code{\link{read.CBData}} for creating a \code{CBData} object directly from a file.}
\examples{
data(shelltox)
sh <- CBData(shelltox, trt="Trt", clustersize="ClusterSize", nresp="NResp")
str(sh)
}
\keyword{ classes }
\keyword{ manip }
