% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-methods.R
\name{plot,DeponsRaster,ANY-method}
\alias{plot,DeponsRaster,ANY-method}
\alias{plot.DeponsRaster}
\alias{plot,DeponsRaster,DeponsTrack-method}
\title{Plot a DeponsRaster object}
\usage{
\S4method{plot}{DeponsRaster,ANY}(x, y, col, trackToPlot = 1, ...)
}
\arguments{
\item{x}{\code{DeponsRaster} object}

\item{y}{A \code{DeponsTrack} object or missing}

\item{col}{A color palette, i.e. a vector of n contiguous colors. Reasonable
defaults are provided.}

\item{trackToPlot}{Integer indicating which track to plot if the DeponsTrack
object contains more than one track. Ignored if \code{y} is missing}

\item{...}{Other optional plotting parameters, including 'axes', 'legend',
and 'main'.}
}
\value{
No return value, called for side effects
}
\description{
Plot the values in a DeponsRaster object. Porpoisetracks or
other kinds of lines, poits etc. can be drawn on top of the plot by adding
}
\examples{
\donttest{
data("bathymetry")
data(coastline)
library(sp)
coastline2 <- spTransform(coastline, crs(bathymetry))
bbox <- bbox(bathymetry)
clip.poly <- make.clip.poly(bbox, crs(bathymetry))
if(!identical(crs(bathymetry), crs(coastline2))) stop("Non-matching CRSs")
new.coastline <- rgeos::gIntersection(coastline2, clip.poly, byid = TRUE, drop_lower_td = TRUE)

plot(new.coastline, lwd=0.001)
plot(bathymetry, add=TRUE)
plot(new.coastline, add=TRUE, col="lightyellow2")
plot(clip.poly, add=TRUE)
}
}
\seealso{
See method for \code{\link[raster]{plot}} in the \code{raster}
package for plotting parameters and \code{\link{plot.DeponsTrack}} for
plotting of DeponsRasters cropped to the extent of tracks.
}
