% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{sim_data}
\alias{sim_data}
\title{Simulate data from a multivariate normal distribution.}
\usage{
sim_data(n, k, cor = NULL, exact = TRUE, seed = NULL)
}
\arguments{
\item{n}{Number of observations (cases).}

\item{k}{Number of variables. Will be ignored if \code{cor} specifies a correlation matrix.}

\item{cor}{A correlation value or correlation matrix of the variables. Defaults to \code{NULL} that generates completely random data regardless of their empirical correlations.}

\item{exact}{Ensure the sample correlation matrix to be exact as specified in \code{cor}. This argument is passed on to \code{empirical} in \code{\link[MASS:mvrnorm]{mvrnorm()}}. Defaults to \code{TRUE}.}

\item{seed}{Random seed for replicable results. Defaults to \code{NULL}.}
}
\value{
Return a data.frame of simulated data.
}
\description{
Simulate data from a multivariate normal distribution.
}
\examples{
d1 = sim_data(n=100, k=5, seed=1)
cor_network(d1)

d2 = sim_data(n=100, k=5, cor=0.2, seed=1)
cor_network(d2)

cor.mat = matrix_cor(
  1.0, 0.7, 0.3,
  0.7, 1.0, 0.5,
  0.3, 0.5, 1.0
)
d3 = sim_data(n=100, cor=cor.mat, seed=1)
cor_network(d3)

}
\seealso{
\code{\link[=matrix_cor]{matrix_cor()}}

\code{\link[=sim_data_exp]{sim_data_exp()}}
}
