% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeTopFinder.R
\name{TreeTopFinder}
\alias{TreeTopFinder}
\title{Treetop Finder}
\usage{
TreeTopFinder(CHM, winFun, minHeight = NULL, maxCells = 2e+06,
  maxWinDiameter = 30, verbose = FALSE)
}
\arguments{
\item{CHM}{Canopy height model. Either in \link[raster]{raster} format, or a path directing to a raster file. A character vector of multiple paths directing to a
tiled raster dataset can also be used.}

\item{winFun}{function. The function that determines the size of the window at any given location on the
canopy. It should take the value of a given \code{CHM} pixel as its only argument, and return the desired radius of
the circular search window when centered on that pixel.}

\item{minHeight}{numeric. The minimum height value for a \code{CHM} pixel to be considered as a potential treetop. All \code{CHM} pixels beneath
this value will be masked out.}

\item{maxCells}{numeric. If the number of raster cells (i.e.: pixels) for the \code{CHM} exceeds this value,
the \link[TileManager]{TileScheme} function
will be applied internally to break apart the CHM into tiles to speed up processing.}

\item{maxWinDiameter}{numeric. This parameter sets a cap on the maximum window size. If an improperly calibrated
function is set for \code{winFun}, it may produce overly large windows that would perform poorly and significantly
slow processing time. This setting can be disabled by setting to \code{NULL}.}

\item{verbose}{logical. Print progress to console if set to \code{TRUE}.}
}
\value{
\link[sp]{SpatialPointsDataFrame}. The point locations of detected treetops. The object contains two fields in its
data table: \emph{height} is the height of the tree, as extracted from the \code{CHM}, and \emph{winRadius} is the radius
of the search window when the treetop was detected. Note that \emph{winRadius} does not necessarily correspond to the radius
of the tree's crown.
}
\description{
Implements the variable window filter algorithm (Popescu & Wynne, 2004) for detecting treetops from a canopy height model.
}
\examples{
# Set function for determining variable window radius
winFunction <- function(x){x * 0.06 + 0.5}

# Set minimum tree height (treetops below this height will not be detected)
minHgt <- 2

# Detect treetops in demo canopy height model
ttops <- TreeTopFinder(CHMdemo, winFunction, minHgt)
}
\references{
Popescu, S. C., & Wynne, R. H. (2004). Seeing the trees in the forest. \emph{Photogrammetric Engineering & Remote Sensing, 70}(5), 589-604.
}
\seealso{
\code{\link{SegmentCrowns}} \code{\link{SpatialStatistics}}
}

