% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwcs.R
\name{mcws}
\alias{mcws}
\title{Marker-Controlled Watershed Segmentation}
\usage{
mcws(
  treetops,
  CHM,
  minHeight = 0,
  format = "raster",
  OSGeoPath = NULL,
  IDfield = "treeID"
)
}
\arguments{
\item{treetops}{sf. The point locations of treetops in \code{sf} format.}

\item{CHM}{SpatRaster. Canopy height model in \code{SpatRaster} format. This should be the same CHM that was used to the detect the \code{treetops}.}

\item{minHeight}{numeric. The minimum height value for a \code{CHM} pixel to be considered as part of a crown segment.
All \code{CHM} pixels beneath this value will be masked out. Note that this value should be lower than the minimum
height of \code{treetops}.}

\item{format}{string. Format of the function's output. Can be set to either 'raster' or 'polygons'.}

\item{OSGeoPath}{character. Obsolete. Will be removed next version}

\item{IDfield}{character. Name of the field for storing the unique tree identifier}
}
\value{
Depending on the setting for \code{format}, this function will return a map of outlined
crowns as either a \code{SpatRaster} class object, in which distinct crowns are given a unique cell value, or a \code{sf} class object, in which each crown
is represented by a polygon.
}
\description{
This function implements the \link[imager]{watershed} function to segment (i.e.: outline) crowns from a CHM (canopy height model).
Segmentation is guided by the point locations of treetops, typically detected using the \link{vwf} function.
See Meyer & Beucher (1990) for details on watershed segmentation.
}
\details{
Crown segments are returned as either a \code{SpatRaster} or a \code{sf} (Simple Feature) class object,
as defined using the \code{format} argument. For many analytic purposes, it is preferable to have
crown outlines as polygons. However, polygonal crown maps take up significantly more disk space, and take
longer to process. It is advisable to run this function using a raster output first to review
results and adjust parameters.

NOTE: when setting \code{format} to 'polygons', orphaned segments (i.e.: outlines without an associated treetop) will be removed.
This will NOT occur using 'raster' format. This issue will be resolved eventually but requires the watershed function to
be rewritten.
}
\examples{
\dontrun{
library(terra)
library(ForestTools)

chm <- rast(kootenayCHM)

# Use variable window filter to detect treetops
ttops <- vwf(chm, winFun = function(x){x * 0.06 + 0.5}, minHeight = 2)

# Segment tree crowns
segs <- mcws(ttops, chm, minHeight = 1)
}

}
\references{
Meyer, F., & Beucher, S. (1990). Morphological segmentation. \emph{Journal of visual communication and
image representation, 1}(1), 21-46.
}
\seealso{
\code{\link{vwf}}
}
