% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemTax_3_3.R
\name{gemTax_3_3}
\alias{gemTax_3_3}
\title{Some General Equilibrium Models with Tax}
\usage{
gemTax_3_3(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
Some general equilibrium models with tax.
}
\examples{
\donttest{
#### turnover tax.
dst.firm <- node_new("prod",
                     type = "FIN",
                     rate = c(1, tax.rate = 0.25),
                     "cc1", "tax"
)
node_set(dst.firm, "cc1",
         type = "CD",
         alpha = 2, beta = c(0.5, 0.5),
         "prod", "lab"
)

dst.laborer <- dst.government <-
  node_new("util",
    type = "Leontief",
    a = 1,
    "prod"
  )

ge.TT <- sdm2(
  A = list(dst.firm, dst.laborer, dst.government),
  B = diag(c(1, 0, 0)),
  S0Exg = matrix(c(
    NA, NA, NA,
    NA, 100, NA,
    NA, NA, 100
  ), 3, 3, TRUE),
  names.commodity = c("prod", "lab", "tax"),
  names.agent = c("firm", "laborer", "government"),
  numeraire = "prod"
)

ge.TT$p
ge.TT$z
ge.TT$D
ge.TT$S

#### product tax.
dst.taxed.prod <- node_new("taxed.prod",
                           type = "FIN",
                           rate = c(1, tax.rate = 0.25),
                           "prod", "tax"
)

dst.firm <- node_new("prod",
                     type = "CD",
                     alpha = 2, beta = c(0.5, 0.5),
                     dst.taxed.prod, "lab"
)

dst.laborer <- dst.government <-
  node_new("util",
    type = "Leontief",
    a = 1,
    dst.taxed.prod
  )

ge.PT <- sdm2(
  A = list(dst.firm, dst.laborer, dst.government),
  B = diag(c(1, 0, 0)),
  S0Exg = matrix(c(
    NA, NA, NA,
    NA, 100, NA,
    NA, NA, 100
  ), 3, 3, TRUE),
  names.commodity = c("prod", "lab", "tax"),
  names.agent = c("firm", "laborer", "government"),
  numeraire = "prod"
)

ge.PT$p
ge.PT$z
ge.PT$D
ge.PT$S

#### consumption tax.
dst.firm <- node_new("output",
                     type = "CD", alpha = 2,
                     beta = c(0.5, 0.5),
                     "prod", "lab"
)

dst.laborer <- node_new("util",
                        type = "FIN",
                        rate = c(1, consumption.tax.rate = 1/3),
                        "prod", "tax"
)

dst.government <- node_new("utility",
                           type = "Leontief",
                           a = 1,
                           "prod"
)

ge.CT <- sdm2(
  A = list(dst.firm, dst.laborer, dst.government),
  B = diag(c(1, 0, 0)),
  S0Exg = matrix(c(
    NA, NA, NA,
    NA, 100, NA,
    NA, NA, 100
  ), 3, 3, TRUE),
  names.commodity = c("prod", "lab", "tax"),
  names.agent = c("firm", "laborer", "government"),
  numeraire = "prod"
)

ge.CT$p
ge.CT$z
ge.CT$D
ge.CT$S

#### value added tax.
dst.firm <- node_new("output",
  type = "CD", alpha = 2,
  beta = c(0.5, 0.5),
  "prod", "taxed.lab"
)
node_set(dst.firm, "taxed.lab",
  type = "FIN",
  rate = c(1, vat.rate = 1/3),
  "lab", "tax"
)

dst.laborer <- dst.government <-
  node_new("util",
    type = "Leontief",
    a = 1,
    "prod"
  )

ge.VAT <- sdm2(
  A = list(dst.firm, dst.laborer, dst.government),
  B = diag(c(1, 0, 0)),
  S0Exg = matrix(c(
    NA, NA, NA,
    NA, 100, NA,
    NA, NA, 100
  ), 3, 3, TRUE),
  names.commodity = c("prod", "lab", "tax"),
  names.agent = c("firm", "laborer", "government"),
  numeraire = "prod"
)

ge.VAT$p
ge.VAT$z
ge.VAT$D
ge.VAT$S

#### income tax.
income.tax.rate <- 1 / 4

dst.firm <- node_new("output",
                     type = "CD",
                     alpha = 2, beta = c(0.5, 0.5),
                     "prod", "lab"
)

dst.laborer <- dst.government <-
  node_new("util",
    type = "Leontief",
    a = 1,
    "prod"
  )

ge.IT <- sdm2(
  A = list(dst.firm, dst.laborer, dst.government),
  B <- diag(c(1, 0), 2, 3),
  S0Exg = matrix(c(
    NA, NA, NA,
    NA, 100 * (1 - income.tax.rate), 100 * income.tax.rate
  ), 2, 3, TRUE),
  names.commodity = c("prod", "lab"),
  names.agent = c("firm", "laborer", "government"),
  numeraire = "prod"
)

ge.IT$p
ge.IT$z
ge.IT$D
ge.IT$S

#### turnover tax (Li, 2019, example 4.11).
dst.firm <- node_new("output",
                     type = "FIN",
                     rate = c(1, turnover.tax.rate = 1),
                     "cc1", "tax"
)
node_set(dst.firm, "cc1",
         type = "CD",
         alpha = 1, beta = c(0.5, 0.5),
         "prod", "lab"
)

dst.laborer1 <- node_new("util",
                          type = "CD",
                          alpha = 1, beta = c(0.5, 0.5),
                          "prod", "lab"
)

dst.laborer2 <- node_new("utility",
                          type = "Leontief",
                          a = 1,
                          "prod"
)

ge.TT2 <- sdm2(
  A = list(dst.firm, dst.laborer1, dst.laborer2),
  B = diag(c(1, 0, 0)),
  S0Exg = matrix(c(
    NA, NA, NA,
    NA, 100, NA,
    NA, NA, 100
  ), 3, 3, TRUE),
  names.commodity = c("prod", "lab", "tax"),
  names.agent = c("firm", "laborer1", "laborer2"),
  numeraire = "lab"
)

ge.TT2$p
ge.TT2$z

#### commodity tax in a pure exchange economy.
tax.rate <- 0.25
es.consumer1 <- 0.5
es.consumer2 <- 2

dst.consumer1 <- node_new("util",
                          type = "SCES", es = es.consumer1,
                          alpha = 1, beta = c(0.5, 0.5),
                          "comm1", "comm2"
)

dst.consumer2 <- node_new("util",
                          type = "SCES", es = es.consumer2,
                          alpha = 1, beta = c(0.5, 0.5),
                          "taxed.comm1", "comm2"
)
node_set(dst.consumer2, "taxed.comm1",
         type = "FIN",
         rate = c(1, tax.rate = tax.rate),
         "comm1", "tax"
)

dst.gov <- node_new("util",
                    type = "SCES", es = 0,
                    alpha = 1, beta = c(0.5, 0.5),
                    "comm1", "comm2"
)

ge.CT <- sdm2(
  A = list(dst.consumer1, dst.consumer2, dst.gov),
  B = matrix(0, 3, 3),
  S0Exg = matrix(c(
    100, NA, NA,
    NA, 100, NA,
    NA, NA, 100
  ), 3, 3, TRUE),
  names.commodity = c("comm1", "comm2", "tax"),
  names.agent = c("consumer1", "consumer2", "gov"),
  numeraire = "comm1"
)

ge.CT$p
ge.CT$z
ge.CT$D
}
}
\references{
LI Wu (2019, ISBN: 9787521804225) General Equilibrium and Structural Dynamics: Perspectives of New Structural Economics. Beijing: Economic Science Press. (In Chinese)
}
