% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPPFourier.R
\name{GPPFourier}
\alias{GPPFourier}
\title{Calculate GPP from O2 time series}
\usage{
GPPFourier(x, dt = NULL, units = c("days", "hours", "mins"), Nfilt = NULL,
  fDL = NULL, filtcorrect = FALSE, phi = NULL, lambda = NULL, ...)
}
\arguments{
\item{x}{Regularly sampled O2 time series. x can be a dataframe with time (POSIXt) in first column and O2 concentrations in 
second column or a vector of concentrations sampled with time step = dt}

\item{dt}{Sampling time step. Not used when x is a data frame, then dt is calculated #' from the time spacing between 
the first two samples. Either a difftime object or a numerical value. When dt is given as a numerical value, \code{units} 
have to be provided.}

\item{units}{Unit of sampling time step}

\item{Nfilt}{Moving average filter width}

\item{fDL}{Relative fraction of light hours during the day. When \code{x} is a data frame, and no value for fDL is provided, 
fDL is calculated with \code{\link{fDLfun}}}

\item{filtcorrect}{Logical controlling whether GPP estimate
is corrected for signal falsely removed by filtering}

\item{phi}{Optional: Lattitude. Only used when fDL=NULL and daylength is calculated with \code{\link{fDLfun}}}

\item{lambda}{Optional: Lattitude. Only used when fDL=NULL and daylength is calculated with \code{\link{fDLfun}}}

\item{...}{Other parameters to be passed to \code{\link{GPPFourierPreprocess}}}
}
\value{
Volume specific average gross primary production in units of oxgen as in \code{x}. 
per time unit (unit of \code{dt}, given by \code{units}). 
Specifically: if O2 concentrations are in mg/L, and \code{units = days}, calculated GPP has units mg/L/day.
If surface specific primary production (e.g. per m2) is desired, this number has to be multiplied by the depth of the water body.
}
\description{
This is the workhorse to calculate aquatic Gross Primary Production from
high frequency dissolved oxygen data. It will often be more convenient to use the higher
level functions \code{\link{WindowGPPFourier}} and
\code{\link{WindowGPPFourier.gts}}
}
\details{
no details
}
\examples{
DO <- Kruibeke[Kruibeke$time>="2010-06-03"&Kruibeke$time<="2010-06-13",]
dt <- as.numeric(difftime(DO$time[2],DO$time[1],units="days"))
DL <- fDLfun(DO$time[1], phi=51.176, lambda=4.326) 
GPP <- GPPFourier(DO$O2,dt=dt,Nfilt=100,fDL=DL)

}
\references{
Cox T.J.S. et al. (2015) 'Estimating primary production from oxygen time series: a novel approach in the frequency domain', Limnology And Oceanography:Methods 13, 529-552. DOI: 10.1002/lom3.10046
}
\seealso{
\code{\link{GPPFourierPreprocess}}, \code{\link{GPPFourier_t}}, \code{\link{WindowGPPFourier}},
\code{\link{WindowGPPFourier.gts}}
}
\author{
Tom Cox <tom.cox@uantwerp.be>
}
\keyword{utilities}
