% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPPFourier.R
\name{WindowGPPFourier.gts}
\alias{WindowGPPFourier.gts}
\title{Calculate GPP from O2 time series with gaps, in consecutive time-windows of prescribed
length}
\usage{
WindowGPPFourier.gts(x, dt = difftime(x[2, 1], x[1, 1], units = "days"),
  units = c("days", "hours", "mins"), gapMaxN = 4/24/dt, Width = 14,
  filtWidth = 16, ...)
}
\arguments{
\item{x}{Dataframe containing time (POSIXt) in first column and O2 concentrations in the second column.}

\item{dt}{Sampling time step. Either a difftime object or a numerical value. 
When \code{dt} is given as a numerical value, \code{units} have to be provided (defaults to \code{days}). When omitted \code{dt} is calculated from the time spacing between the first two samples in the data frame.}

\item{units}{Unit of sampling time step}

\item{gapMaxN}{Minimum number of missing data points to be considered a gap in the time series. Gaps smaller than gapMaxN are interpolated. Defaults to the number of samples corresponding to a 4 hour gap.}

\item{Width}{Width [days] of the time-windows for which GPP is calculated}

\item{filtWidth}{Length of moving average filter [hours] to filter O2}

\item{...}{Other parameters to be passed to WindowGPPFourier()}
}
\value{
Average gross primary production in units of oxgen as in \code{x}
per day.
}
\description{
Calculate GPP from O2 time series in consecutive time-windows of prescribed
length. High level function to handle time series with gaps. Short gaps are
interpolated, series is split at large gaps.
}
\details{
This high level function analyses multiple regular O2 time series at once, each separated by a gap larger than gapMaxN (the number of . This is convenient e.g. for regular O2 data from a single location, where some data is missing due to sensor maintenance or replacement. \code{x} is assumed to contain all these data, pasted together in a single data frame (e.g. by \code{\link{cbind}}ing all individual regular time series or just reading from a single data file). Additionally, missing values within the regular series are allowed and are interpolated with \code{\link{gapfill}}. Uses \code{\link{WindowGPPFourier}}.
}
\examples{
par(mfrow=c(2,1))
plot(Kruibeke, pch=20,xlim=as.POSIXct(c("2010-01-01", "2010-12-31")))
GPPAll_4 <- WindowGPPFourier.gts(Kruibeke, 
                                 gapMaxN = 10, 
                                 Width = 10, 
                                 filtWidth=1*24, 
                                 phi=51.176,
                                 lambda=4.326, 
                                 Detrend=TRUE, 
                                 filter=TRUE, 
                                 filtcorrect=FALSE)
plot(GPPAll_4$time,GPPAll_4$GPP*9.3, 
     col="black", 
    pch=19, 
    type="b", 
    xlab="time", 
    ylab="GPP", 
    xlim=as.POSIXct(c("2010-01-01", "2010-12-31")))

}
\references{
Cox T.J.S. et al. (2015) 'Estimating primary production from oxygen time series: a novel approach in the frequency domain', Limnology And Oceanography:Methods 13, 529-552. DOI: 10.1002/lom3.10046
}
\seealso{
\code{\link{GPPFourierPreprocess}}, \code{\link{GPPFourier_t}}, \code{\link{SunRiseSet}},
\code{\link{WindowGPPFourier}}
}
\author{
Tom Cox <tom.cox@uantwerp.be>
}
\keyword{utilities}
