% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsnMergePathways.R
\name{gsnMergePathways}
\alias{gsnMergePathways}
\title{gsnMergePathways}
\usage{
gsnMergePathways(
  object,
  pathways.data = NULL,
  distance = NULL,
  id_col = NULL,
  stat_col = NULL,
  sig_order = NULL
)
}
\arguments{
\item{object}{A GSNData object upon which \code{gsnAssignSubnets()} has been called.}

\item{pathways.data}{(optional) data.frame containing a pathways results. Not necessary if pathways data have already
been imported.}

\item{distance}{(optional) character vector of length 1 indicating which set of subnets to be used if the GSNData object
contains subnets derived from more than one distance matrix.}

\item{id_col}{(optional) ID column to be used for merging subnets. Defaults to the value of \code{id_col} already set
during import of pathways data, if that has already been done.}

\item{stat_col}{(optional) The name of the column column containing the statistic to be used for ordering subnets
and performing intra-subnet ranking. Defaults to the value of \code{stat_col} already set during import of pathways
data, if that has already been done.}

\item{sig_order}{(optional) Character vector of length 1 indicating the whether low values of the statistic are most
significant ("loToHi", the default) or high values ("hiToLo") for ordering subnets and performing. Defaults to the
value of \code{sig_order} already set during import of pathways data, if that has already been done.}
}
\value{
A data.frame containing pathways data with merged subnet assignments and subnetRank values.
}
\description{
Merge pathways data and subnets into a data.frame that includes subnet assignment and intra-subnet rank.
}
\details{
In the standard workflow, just the object parameter is generally necessary. If subnets have been calculated for
multiple distance matrices and the subnets desired are not associated with the current default distance, then the
\code{distance} parameter can be specified.
}
\examples{

library(GSNA)

# In this example, we generate a gene set network from CERNO example
# data. We begin by subsetting the CERNO data for significant results:
sig_pathways.cerno <- subset( Bai_CiHep_DN.cerno, adj.P.Val <= 0.05 )

# Now create a gene set collection containing just the gene sets
# with significant CERNO results, by subsetting Bai_gsc.tmod using
# the gene set IDs as keys:
sig_pathways.tmod <- Bai_gsc.tmod[sig_pathways.cerno$ID]

# And obtain a background gene set from differential expression data:
background_genes <- toupper( rownames( Bai_CiHep_v_Fib2.de ) )

# Build a gene set network:
sig_pathways.GSN <-
   buildGeneSetNetworkJaccard(geneSetCollection = sig_pathways.tmod,
                              ref.background = background_genes )

# Now import the CERNO data:
sig_pathways.GSN <- gsnImportCERNO( sig_pathways.GSN,
                                    pathways_data = sig_pathways.cerno )

# Now we can pare the network and assign subnets:
sig_pathways.GSN <- gsnPareNetGenericHierarchic( object = sig_pathways.GSN )
sig_pathways.GSN <- gsnAssignSubnets(  object = sig_pathways.GSN )

# Now, we can use gsnMergePathways to output a table of pathway data
# with merged subnets:
gsnMergePathways( sig_pathways.GSN )


}
\seealso{
\code{\link{gsnAddPathwaysData}()}
\code{\link{gsnImportCERNO}()}
\code{\link{gsnImportGSNORA}()},
\code{\link{gsnImportGSEA}()}
\code{\link{gsnImportGenericPathways}()}
}
