% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTwoColorEncodeFunction.R
\name{makeTwoColorEncodeFunction}
\alias{makeTwoColorEncodeFunction}
\title{makeTwoColorEncodeFunction}
\usage{
makeTwoColorEncodeFunction(
  numbers.1,
  numbers.2,
  colors.1 = c("#FFFFFF", "#FF0000"),
  colors.2 = c("#FFFFFF", "#0000FF"),
  combine_method = "mean",
  c1.fun = NULL,
  c2.fun = NULL,
  na.color = "#CCCCCC"
)
}
\arguments{
\item{numbers.1}{A set of numbers to define the range of channel 1 numerical values for which the color encode
function will be defined. Only the extreme min and max values are necessary.}

\item{numbers.2}{A set of numbers to define the range of channel 2 numerical values for which the color encode
function will be defined. Only the extreme min and max values are necessary.}

\item{colors.1}{The range of channel 1 colors to be returned by the function function. (default: c("#FFFFFF", "#FF0000"))}

\item{colors.2}{The range of channel 2 colors to be returned by the function function. (default: c("#FFFFFF", "#0000FF"))}

\item{combine_method}{(optional) For dual channel plots this is a string used to indicate how colors are combined to
generate a two dimensional color scale. Options are "scaled_geomean" (same as "default"), "standard" (same as "euclidean" ),
"negative_euclidean", "mean", and "additive". See details.}

\item{c1.fun}{(optional) A function to convert the numerical in channel 1 into colors. If not specified, this is
generated based on \code{numbers.1} and \code{colors.1}.}

\item{c2.fun}{(optional) A function to convert the numerical in channel 2 into colors. If not specified, this is
generated based on \code{numbers.2} and \code{colors.2}.}

\item{na.color}{(optional) The color returned from the function for NA values (default: "#CCCCCC").}
}
\value{
\code{makeTwoColorEncodeFunction()} returns a function that takes 3 arguments and returns either a vector of
hexadecimal colors or a 3-column matrix of columns. The arguments:
\item{\code{numbers.1}}{A vector of numbers for channel 1, to be encoded as a color value.}
\item{\code{numbers.2}}{A vector of numbers for channel 2, to be encoded as a color value.}
\item{\code{output_as}}{Specifies the type of return value. If \code{'vector'} or \code{'rgb'}, the function returns a vector
of hexadecimal colors (e.g."#FFCCAA"), if 'matrix','array', a three column numeric matrix is returned (Columns are "R", "G", or "B").
Currently, \code{'vector'} are synonyms \code{'rgb'}, as are \code{'matrix'} and \code{'array'}}.
}
\description{
Generate a function to take two numerical vector arguments and return a color, either as a vector of
hexadecimal encoded colors, or as a three column matrix.
}
\examples{

# Prepare the function:
twoColorEnc.fun <- makeTwoColorEncodeFunction( numbers.1 = c( 0.4, 6 ),
                                               numbers.2 = c(0.6, 20),
                                               colors.1 = c("white", "red"),
                                               colors.2 = c("white", "green" ),
                                               combine_method = "mean" )
# Encode two vectors of numbers as a single vector of colors:
colors_as_vector <- twoColorEnc.fun( numbers.1 = c( 0.4, 1.2, 5, 6 ),
                                     numbers.2 = c( 0.6, 6, 9, 20 ),
                                     output_as = 'vector' )

}
