% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VersionValidation.R
\name{validateVersion}
\alias{validateVersion}
\title{Validate an IPD-IMGT/HLA Release Version}
\usage{
validateVersion(version)
}
\arguments{
\item{version}{A character string identifying the release version (branch) of the ANHIG/IMGTHLA Github repository (e.g. '3.53.0'). The value 'Latest' refers to the most recent release.}
}
\value{
A logical. TRUE indicates that data for 'version' is available in the ANHIG/IMGTHLA GitHub repository. FALSE means that data for 'version' is not available.
}
\description{
Determines if an IPD-IMGT/HLA Release Version is referenced in the AlleleListHistory file.
}
\note{
For internal HLAtools use.
}
\examples{
validateVersion(version = "3.31.1")
validateVersion(version = "3.13.0")

}
