% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qSIP_trans.R
\name{OTU_qPCR_trans}
\alias{OTU_qPCR_trans}
\title{Transform OTU counts based on qPCR data}
\usage{
OTU_qPCR_trans(physeq, qPCR, sample_idx = "Sample",
  value_idx = "qPCR_tech_rep_mean")
}
\arguments{
\item{physeq}{A phyloseq object}

\item{qPCR}{Either a list or a data.frame of qPCR data.
If a list, the list should include a 'summary' tag as is produced
from \code{qPCR_sim()}.
If a data.frame, the table should be formatted as the 'summary' table
produced from \code{qPCR_sim()}.}

\item{sample_idx}{The qPCR table column index for
matching to otu table samples.}

\item{value_idx}{The qPCR table column index for qPCR values.}
}
\value{
A phyloseq object with transformed OTU counts
}
\description{
OTU counts in the phyloseq otu_table object will be normalized
to sample totals (total sum scaling), then multiplied by the
qPCR value associated with each sample. Thus, the qPCR table
should have ONE value matching the OTU count table. Value
matching between the OTU table & qPCR value table to set by
\code{sample_idx()}.
}
\details{
Note: only the 'summa
}
\examples{
# qPCR data simulation
data(physeq_rep3)
data(physeq_rep3_qPCR)
physeq_rep3_t = OTU_qPCR_trans(physeq_rep3, physeq_rep3_qPCR)

}

