% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractImages_toMatrix.R
\name{ExtractImages_toMatrix}
\alias{ExtractImages_toMatrix}
\title{Shorcut for Batch Images Extraction to Matrices/Arrays}
\usage{
ExtractImages_toMatrix(..., objects, offsets, display_progress = TRUE)
}
\arguments{
\item{...}{arguments to be passed to \code{\link{objectExtract}} with the exception of 'ifd' and 'bypass'(=TRUE).\cr
If 'param' is provided 'export'(="matrix") will be overwritten.\cr
If 'offsets' are not provided extra arguments can also be passed with ... \code{\link{getOffsets}}.\cr
/!\ If not any of 'fileName', 'info' and 'param' can be found in ... then attr(offsets, "fileName_image") will be used as 'fileName' input parameter to pass to \code{\link{objectParam}}.}

\item{objects}{integer vector, IDEAS objects ids numbers to use.
This argument is not mandatory, if missing, the default, all objects will be used.}

\item{offsets}{object of class `IFC_offset`. 
This argument is not mandatory but it may allow to save time for repeated image export on same file.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}
}
\value{
A list of matrices/arrays of images corresponding to objects extracted.
}
\description{
Function to shortcut extraction, normalization and eventually colorization of images to matrix ! excludes mask.
}
\details{
arguments of \code{\link{objectExtract}} will be deduced from \code{\link{ExtractImages_toMatrix}} input arguments.
}
