% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings_utils.R
\name{gen_altnames}
\alias{gen_altnames}
\title{Alternative Names Generator}
\usage{
gen_altnames(
  x,
  n = 10,
  forbidden = character(),
  random_seed = list(seed = 252, "Mersenne-Twister", "Inversion", "Rounding")
)
}
\arguments{
\item{x}{a character vector.}

\item{n}{number of characters of the desired returned name. Default is 10.}

\item{forbidden}{forbidden character vector. Default is character().}

\item{random_seed}{a list of elements to pass to \link[base]{set.seed} or a single value, interpreted as an integer, or NULL.
Default is list(seed = 0xFC, "Mersenne-Twister", "Inversion", "Rounding").
Note that NA_integer_ or list(seed = NA_integer_) can be used to not call \link[base]{set.seed} at all.
Note also that the default is chosen because it is compatible with old R version.}
}
\value{
a character vector.
}
\description{
Generates unique non matching alternative names
}
\details{
'forbidden' should not encompass all possible returned value otherwise the function will never end.
}
\keyword{internal.}
