% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top.discriminator.R
\name{top.discriminator}
\alias{top.discriminator}
\title{Detecting top discriminators between two groups}
\usage{
top.discriminator(
  cluster.obj = NULL,
  group1,
  group2,
  bim.file,
  use.node.number = FALSE,
  num.top = 100,
  percentile = 0.9,
  use.percentile = FALSE,
  use.path = FALSE,
  result.path = NULL
)
}
\arguments{
\item{cluster.obj}{The object which is returned from \code{\link{ipcaps}}.
This parameter is used when \code{use.path} is FALSE.}

\item{group1}{To specify the first group number to be compared. (also see
\code{use.node.number})}

\item{group2}{To specify the second group number to be compared. (also see
\code{use.node.number})}

\item{bim.file}{Option: In case that SNP information is not provided to
\code{\link{ipcaps}}, an absolute path of SNP information file is required.
It needs to be in PLINK format (bim). See more details at:
\url{http://zzz.bwh.harvard.edu/plink/data.shtml}.}

\item{use.node.number}{To specify whether a group number or a node number
is be used. If TRUE, a node nubmer is used instead. Default = FALSE.}

\item{num.top}{A number of top Fst SNPs to be returned. This parameter is
used when \code{percentile} is FALSE. Default = 100.}

\item{percentile}{A percentile for top Fst SNPs to be returned. This parameter
is used when \code{percentile} is TRUE. Default = 0.999.}

\item{use.percentile}{A logical value to indicate whether \code{percentile}
is used instead of \code{num.top}. This parameter is used when \code{percentile}
is TRUE. Default = FALSE.}

\item{use.path}{A logical value to indicate whether \code{result.path} is
used instead of \code{cluster.obj}. Importantly, \code{result.path} needs to
be set. This parameter only work with the IPCAPS's result from version 1.1.7
onward. Default = FALSE.}

\item{result.path}{A path to an result directory of IPCAPS. This parameter is
used when \code{use.path} is TRUE. This parameter only work with the IPCAPS's
result from version 1.1.7 onward.}
}
\value{
The returned value is a data.frame of SNP information sorting by Fst
in descending order, which contains 7 columns, chr, SNP, centimorgans,
position, allele1, allele2, and Fst. The column 1-6 are SNP information from
the bim file. The column Fst contains estimated Fst between group1 and group2.
}
\description{
Detects top discriminators that contribute to
group separation based on the fixation index (Fst).
}
\examples{

# Importantly, bed file, bim file, and fam file are required
# Use the example files embedded in the package
BED.file <- system.file("extdata","ipcaps_example.bed",package="IPCAPS")
LABEL.file <- system.file("extdata","ipcaps_example_individuals.txt.gz",package="IPCAPS")
my.cluster <- ipcaps(bed=BED.file,label.file=LABEL.file,lab.col=2,out=tempdir())
table(my.cluster$cluster$label,my.cluster$cluster$group)
# 1 2 3 4 5 6
# outlier4 5 4 1 0 0 0
# pop1 0 0 0 0 250 0
# pop2 0 0 0 0 0 250
# pop3 0 0 0 250 0 0

#Identify top discriminators between groups, for example, group 4 and group 5
top.snp <-top.discriminator(my.cluster,4,5)
#or, specify the bim file
#top.snp <-top.discriminator(my.cluster,4,5,bim.file="ipcaps_example.bim")
head(top.snp)
# chr SNP centimorgans position allele1 allele2 Fst
#V5452 1 marker5452 0 54520000 A T 0.11337260
#V2348 1 marker2348 0 23480000 A T 0.11194490
#V8244 1 marker8244 0 82440000 A T 0.09556580
#V5972 1 marker5972 0 59720000 A T 0.08747794
#V3561 1 marker3561 0 35610000 A T 0.08725860
#V8419 1 marker8419 0 84190000 A T 0.08293494

#Alternatively, specify the previous result directory of IPCAPS and identify
#top discriminators between groups, for example, group 4 and group 5
previous.res.path <- my.cluster$output.dir
top.snp <-top.discriminator(result.path = previous.res.path, use.path = TRUE,
group1 = 4, group2 = 5)
head(top.snp)

#Identify top discriminators between groups, for example, group 4 and group 5
top.snp <-top.discriminator(my.cluster,4,5)
#or, specify the bim file
#top.snp <-top.discriminator(my.cluster,4,5,bim.file="ipcaps_example.bim")
dim(top.snp)
head(top.snp)

#Here, it is possible to select the top Fst SNPs based on a percentile.
top.snp <-top.discriminator(my.cluster,4,5, percentile = 0.9,
use.percentile = TRUE)
dim(top.snp)
head(top.snp)

#Identify top discriminators between groups, for example, node 7 and node 8
top.snp2 <-top.discriminator(my.cluster,7,8,use.node.number=TRUE)
head(top.snp2)
# chr SNP centimorgans position allele1 allele2 Fst
#V5452 1 marker5452 0 54520000 A T 0.11337260
#V2348 1 marker2348 0 23480000 A T 0.11194490
}
