#' 2021 NBA Advanced Statistics (Team) for the 2020-21 Season
#'
#' A dataset containing the NBA Four Factor table on nba.com
#'
#' @format A data frame with 2160 rows and 29 variables:
#' \describe{
#'   \item{idGame}{Game ID on nba.com}
#'   \item{slugTeam}{Team abbreviation}
#'   \item{idTeam}{Team ID on nba.com}
#'   \item{pctAST}{Assist percentage}
#'   \item{pctOREB}{Offensive rebound percentage}
#'   \item{pctDREB}{Defensive rebound percentage}
#'   \item{pctTREB}{Total rebound percentage}
#'   \item{pctTOVE}{Turnover percentage (one)}
#'   \item{pctTOVTeam}{Turnover percentage (two)}
#'   \item{pctEFG}{Effective field goal percentage}
#'   \item{pctTS}{True Shooting percentage}
#'   \item{pctUSG}{Usage metric}
#'   \item{pctUSGE}{Usage percentage}
#'   \item{teamName}{Team Mascot}
#'   \item{cityTeam}{City of slugTeam}
#'   \item{minExact}{Total minutes played}
#'   \item{ortgE}{offensive rating (effective ?)}
#'   \item{ortg}{offensive rating}
#'   \item{drtgE}{defensive rating (effective ?)}
#'   \item{drtg}{defensive rating}
#'   \item{netrtgE}{net rating (effective ?)}
#'   \item{netrtg}{net rating}
#'   \item{ratioASTtoTOV}{Assists to turnover ratio}
#'   \item{ratioAST}{Assist ratio}
#'   \item{paceE}{pace (effective ?)}
#'   \item{pace}{pace}
#'   \item{pacePer40PACE_PER40}{pace per forty minutes}
#'   \item{possessions}{team possessions in game}
#'   \item{ratioPIE}{Player impact estimate}
#' }
#' @source \url{http://asbcllc.com/nbastatR/reference/box_scores.html}
"nba_adv_team_2021"
