% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLikKspm.R
\name{logLik.kspm}
\alias{logLik.kspm}
\title{Log Likelihood of a kspm Object}
\usage{
\method{logLik}{kspm}(object, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \link{kspm}.}

\item{...}{additional optional argument (currently unused).}
}
\value{
logLik of kspm fit
}
\description{
Returns the Log Likelihood value of the kernel semi parametric model represented by \code{obect} evaluated at the estimated coefficients.
}
\details{
The function returns the Log Likelihood computed as follow:  \eqn{logLik = -\frac{1}{2} RSS}{-(1/2)*RSS} where \eqn{RSS}{RSS} is the residual sum of squares.
}
\examples{
x <- 1:15
y <- 3*x + rnorm(15, 0, 2)
fit <- kspm(y, kernel = ~ Kernel(x, kernel.function = "linear"))
logLik(fit)

}
\references{
Liu, D., Lin, X., and Ghosh, D. (2007). Semiparametric regression of multidimensional genetic pathway data: least squares kernel machines and linear mixed models. Biometrics, 63(4), 1079:1088.
}
\seealso{
\link{kspm}, \link{extractAIC.kspm}, \link{deviance.kspm}
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
