% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMOORA.R
\name{MMOORA}
\alias{MMOORA}
\title{Implementation of MULTIMOORA Method for Multi-Criteria Decision Making Problems.}
\usage{
MMOORA(decision, weights, cb)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x \emph{n}) with the values of the \emph{m} alternatives, for the \emph{n} criteria.}

\item{weights}{A vector of length \emph{n}, containing the weights for the criteria. The sum of the weights has to be 1.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}
}
\value{
\code{MMOORA} returns a data frame which contains the scores and the four rankings calculated (Ratio System, Reference Point, Multiplicative Form and Multi-MOORA ranking).
}
\description{
The \code{MMOORA} function implements both the Multi-Objetive Optimization by Ration Analysis (MOORA) and the "Full Multiplicative Form" (MULTIMOORA).
}
\examples{

 d <- matrix(c(60,6.35,6.8,10,2.5,4.5,3,0.4,0.15,0.1,0.2,0.1,0.08,0.1,2540,1016,1727.2,
 1000,560,1016,1778,500,3000,1500,2000,500,350,1000,990,1041,1676,965,915,508,920),
 nrow=7,ncol=5)
 w <- c(0.036,0.192,0.326,0.326,0.12)
 cb <- c('max','min','max','max','max')
 MMOORA(d,w,cb)
}
\references{
Brauers, W. K. M.; Zavadskas, E. K. Project management by MULTIMOORA as an instrument for transition economies. Technological and Economic Development of Economy, 16(1), 5-24, 2010.
}

