% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-utilities.R
\name{is}
\alias{is}
\alias{is_Coo}
\alias{is_PCA}
\alias{is_LDA}
\alias{is_Out}
\alias{is_Opn}
\alias{is_Ldk}
\alias{is_Coe}
\alias{is_OutCoe}
\alias{is_OpnCoe}
\alias{is_LdkCoe}
\alias{is_TraCoe}
\alias{is_shp}
\alias{is_fac}
\alias{is_ldk}
\alias{is_slidings}
\alias{is_links}
\title{Various class/component testers}
\usage{
is_Coo(x)

is_PCA(x)

is_LDA(x)

is_Out(x)

is_Opn(x)

is_Ldk(x)

is_Coe(x)

is_OutCoe(x)

is_OpnCoe(x)

is_LdkCoe(x)

is_TraCoe(x)

is_shp(x)

is_fac(x)

is_ldk(x)

is_slidings(x)

is_links(x)
}
\arguments{
\item{x}{the object to test}
}
\value{
TRUE/FALSE
}
\description{
Class testers test if any of the classes of an object is of a given class. For instance
is.PCA on a PCA object (both 'PCA' and 'prcomp') will return TRUE.
Component testers check if a particular component (eg $fac, etc.) is present.
}
\note{
all \code{is_*} have an \code{is.*} alias
(eg \code{is_Coo} is the same as \code{is.Coo}) but the \code{.} alias will
be deprecated at some point.
}
\examples{
data(bot)
is_Coo(bot)
is_Out(bot)
is_Ldk(bot)
}
