% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-PCA.R
\name{PCA}
\alias{PCA}
\alias{PCA.OutCoe}
\alias{PCA.OpnCoe}
\alias{PCA.LdkCoe}
\alias{PCA.TraCoe}
\alias{PCA.default}
\alias{as_PCA}
\title{Principal component analysis on Coe objects}
\usage{
PCA(x, scale., center, fac)

\method{PCA}{OutCoe}(x, scale. = FALSE, center = TRUE, fac)

\method{PCA}{OpnCoe}(x, scale. = FALSE, center = TRUE, fac)

\method{PCA}{LdkCoe}(x, scale. = FALSE, center = TRUE, fac)

\method{PCA}{TraCoe}(x, scale. = TRUE, center = TRUE, fac)

\method{PCA}{default}(x, scale. = TRUE, center = TRUE, fac = dplyr::tibble())

as_PCA(x, fac)
}
\arguments{
\item{x}{a \link{Coe} object or an appropriate object (eg \link{prcomp}) for \code{as_PCA}}

\item{scale.}{logical whether to scale the input data}

\item{center}{logical whether to center the input data}

\item{fac}{any factor or data.frame to be passed to \code{as_PCA} and for use with \link{plot.PCA}}
}
\value{
a 'PCA' object on which to apply \link{plot.PCA}, among others. This list has several
components, most of them inherited from the \code{prcomp} object:
\enumerate{
\item \code{sdev} the standard deviations of the principal components
(i.e., the square roots of the eigenvalues of the
covariance/correlation matrix, though the calculation
is actually done with the singular values of the data matrix)
\item \code{eig} the cumulated proportion of variance along the PC axes
\item \code{rotation} the matrix of variable loadings (i.e., a matrix whose columns contain the eigenvectors).
The function princomp returns this in the element loadings.
\item \code{center}, scale the centering and scaling used
\item \code{x} PCA scores (the value of the rotated data (the centred (and scaled if requested)
data multiplied by the rotation matrix))
\item other components are inherited from the \code{Coe} object passed to \code{PCA},
eg \code{fac}, \code{mshape}, \code{method}, \code{baseline1} and \code{baseline2}, etc. They
are documented in the corresponding \code{*Coe} file.
}
}
\description{
Performs a PCA on \link{Coe} objects, using \link{prcomp}.
}
\details{
By default, methods on \link{Coe} object do not scale the input data but center them.
There is also a generic method (eg for traditional morphometrics) that centers and scales data.
}
\examples{
bot.f <- efourier(bot, 12)
bot.p <- PCA(bot.f)
bot.p
plot(bot.p, morpho=FALSE)
plot(bot.p, 'type')

op <- npoly(olea, 5)
op.p <- PCA(op)
op.p
plot(op.p, 1, morpho=TRUE)

wp <- fgProcrustes(wings, tol=1e-4)
wpp <- PCA(wp)
wpp
plot(wpp, 1)

# "foreign prcomp"
head(iris)
iris.p <- prcomp(iris[, 1:4])
iris.p <- as_PCA(iris.p, iris[, 5])
class(iris.p)
plot(iris.p, 1)
}
\seealso{
Other multivariate: 
\code{\link{CLUST}()},
\code{\link{KMEANS}()},
\code{\link{KMEDOIDS}()},
\code{\link{LDA}()},
\code{\link{MANOVA_PW}()},
\code{\link{MANOVA}()},
\code{\link{MDS}()},
\code{\link{MSHAPES}()},
\code{\link{NMDS}()},
\code{\link{classification_metrics}()}
}
\concept{multivariate}
