% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrdse.R
\name{nrdse}
\alias{nrdse}
\title{Standard error for nonlinear RDD}
\usage{
nrdse(df, gamma, t, e)
}
\arguments{
\item{df}{Data frame whose columns are outcome Y, treatment Treat, and running variable R, respectively.}

\item{gamma}{Value of the parameters in the structural function.}

\item{t}{Treatment value for calculating the marginal effect.}

\item{e}{Value of the error term for calculating the marginal effect.}
}
\description{
Calculates the standard error for the semiparametric estimates in the nonlinear structural function in RDD
}
\examples{
\donttest{
n <- 500
set.seed(123)
data <- nrddgp(n)
nrdse(data,c(1,1,1),.5,.5)
}
}
