% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.Groupwise}
\alias{summary.Groupwise}
\title{Overview Class Groups}
\usage{
\method{summary}{Groupwise}(object = NULL, ...)
}
\arguments{
\item{object}{A Groupwise object as it is returned by \code{\link{groupwise}}-function.}

\item{...}{Further arguments passed from other methods.}
}
\description{
\code{summary.Groupwise} returns a summarizing overview. For each length the number of permutations consisting of the same set of classes is given.
}
\details{
This function gives an overview of the characteristics of the Groupwise object. 
The number of permutations per size is given. A permutation means that the corresponding cascades contain the same classes but with different order.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
subc = subcascades(predMap,thresh=0.7)
groupwise = groupwise(subc,maxCl=50)

summary(groupwise)
}
\seealso{
\code{\link{groupwise}}, \code{\link{summary.PredictionMap}}, \code{\link{summary.Subcascades}}, \code{\link{summary.Conf}}, \code{\link{summary.ConfusionTable}}
}
