% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaning.R
\name{plr_remove_outliers}
\alias{plr_remove_outliers}
\title{Filter outliers from Power Predicted Data}
\usage{
plr_remove_outliers(data)
}
\arguments{
\item{data}{A resulting dataframe from a power predictive model.}
}
\value{
Returns dataframe with outliers flagged by other functions removed
}
\description{
This function is used to remove outliers (if desired) after putting data 
through a power predictive model, e.g. \code{\link{plr_xbx_model}}.
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
# Perform the power predictive modeling step
test_xbx_wbw_res <- plr_xbx_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL)

# Remove outliers from the modeled data
test_xbx_wbw_res_no_outliers <- plr_remove_outliers(test_xbx_wbw_res)

}
