% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalCirculant.R
\name{NormalCirculant}
\alias{NormalCirculant}
\title{Multivariate normal with Circulant variance matrix.}
\description{
Provides methods for the Normal-Circulant (NCt) distribution, which for a random vector \code{z} of length \code{N} is defined as\preformatted{z ~ NCt(uacf)   <=>   z ~ Normal(0, toeplitz(acf)),
}

where \code{uacf} are the \code{Nu = floor(N/2)+1} unique elements of the autocorrelation vector \code{acf}, i.e.,\preformatted{acf = (uacf, rev(uacf[2:(Nu-1)]),   N even,
    = (uacf, rev(uacf[2:Nu])),      N odd.
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{NormalCirculant$new()}}
\item \href{#method-size}{\code{NormalCirculant$size()}}
\item \href{#method-logdens}{\code{NormalCirculant$logdens()}}
\item \href{#method-grad_full}{\code{NormalCirculant$grad_full()}}
\item \href{#method-clone}{\code{NormalCirculant$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$new(N)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{Size of the NCt random vector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NormalCirculant} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
Get the size of the NCt random vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Size of the NCt random vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-logdens"></a>}}
\if{latex}{\out{\hypertarget{method-logdens}{}}}
\subsection{Method \code{logdens()}}{
Log-density function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$logdens(z, uacf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{Density argument. A vector of length \code{N} or an \verb{N x n_obs} matrix where each column is an \code{N}-dimensional observation.}

\item{\code{uacf}}{A vector of length \code{Nu = floor(N/2)} containing the first half of the autocorrelation (i.e., first row/column) of the Circulant variance matrix.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A scalar or vector of length \code{n_obs} containing the log-density of the NCt evaluated at its arguments.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-grad_full"></a>}}
\if{latex}{\out{\hypertarget{method-grad_full}{}}}
\subsection{Method \code{grad_full()}}{
Full gradient of log-density function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$grad_full(z, uacf, calc_dldz = TRUE, calc_dldu = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{z}}{Density argument.  A vector of length \code{N}.}

\item{\code{uacf}}{A vector of length \code{Nu = floor(N/2)} containing the first half of the autocorrelation (i.e., first row/column) of the Circulant variance matrix.}

\item{\code{calc_dldz}}{Whether or not to calculate the gradient with respect to \code{z}.}

\item{\code{calc_dldu}}{Whether or not to calculate the gradient with respect to \code{uacf}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with elements:
\describe{
\item{\code{ldens}}{The log-density evaluated at \code{z} and \code{uacf}.}
\item{\code{dldz}}{The length-\code{N} gradient vector with respect to \code{z}, if \code{calc_dldz = TRUE}.}
\item{\code{dldu}}{The length-\code{Nu = floor(N/2)+1} gradient vector with respect to \code{uacf}, if \code{calc_dldu = TRUE}.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCirculant$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
