% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{diagram_kpca}
\alias{diagram_kpca}
\title{Calculate the kernel PCA embedding of a group of persistence diagrams.}
\usage{
diagram_kpca(
  diagrams,
  dim = 0,
  t = 1,
  sigma = 1,
  features = 1,
  num_workers = parallelly::availableCores(omit = 1),
  th = 1e-04
)
}
\arguments{
\item{diagrams}{a list of persistence diagrams which are either the output of a TDA/TDAstats calculation like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}, or \code{\link{diagram_to_df}}.}

\item{dim}{the non-negative integer homological dimension in which the distance is to be computed, default 0.}

\item{t}{a positive number representing the scale for the persistence Fisher kernel, default 1.}

\item{sigma}{a positive number representing the bandwidth for the Fisher information metric, default 1}

\item{features}{number of features (principal components) to return, default 1.}

\item{num_workers}{the number of cores used for parallel computation, default is one less than the number of cores on the machine.}

\item{th}{the threshold value under which principal components are ignored (default 0.0001).}
}
\value{
a list containing the elements

\describe{

\item{pca}{the output of kernlab's \code{\link[kernlab]{kpca}} function on the Gram matrix: an S4 object containing the slots `pcv` (a matrix containing the principal component vectors (column wise)), `eig` (the corresponding eigenvalues), `rotated` (the original data projected (rotated) on the principal components) and `xmatrix` (the original data matrix).}

\item{diagrams}{the input `diagrams` argument.}

\item{t}{the input `t` argument.}

\item{sigma}{the input `sigma` argument.}

\item{dim}{the input `dim` argument.}

}
}
\description{
Project a group of persistence diagrams into a low-dimensional embedding space using
a kernelized version of the popular PCA algorithm.
}
\details{
Returns the output of kernlab's \code{\link[kernlab]{kpca}} function on the desired Gram matrix of a group of persistence diagrams
in a particular dimension. The prediction function \code{\link{predict_diagram_kpca}} can be used to 
project new persistence diagrams using an old embedding, and this could be one practical
advantage of using \code{\link{diagram_kpca}} over \code{\link{diagram_mds}}. The embedding coordinates can also
be used for further analysis, or simply as a data visualization tool for persistence diagrams.
}
\examples{

# create six diagrams
D1 <- TDAstats::calculate_homology(TDA::circleUnif(n = 50,r = 1),
                                   dim = 1,threshold = 2)
D2 <- TDAstats::calculate_homology(TDA::sphereUnif(n = 50,d = 2,r = 1),
                                   dim = 1,threshold = 2)
D3 <- TDAstats::calculate_homology(TDA::torusUnif(n = 50,a = 0.25,c = 0.75),
                                   dim = 1,threshold = 2)
D4 <- TDAstats::calculate_homology(TDA::circleUnif(n = 50,r = 1),
                                   dim = 1,threshold = 2)
D5 <- TDAstats::calculate_homology(TDA::sphereUnif(n = 50,d = 2,r = 1),
                                   dim = 1,threshold = 2)
D6 <- TDAstats::calculate_homology(TDA::torusUnif(n = 50,a = 0.25,c = 0.75),
                                   dim = 1,threshold = 2)
g <- list(D1,D2,D3,D4,D5,D6)

# calculate their 2D PCA embedding with sigma = t = 2 in dimension 1
pca <- diagram_kpca(diagrams = g,dim = 1,t = 2,sigma = 2,features = 2,num_workers = 2)
}
\references{
Scholkopf, B and Smola, A and Muller, K (1998). "Nonlinear Component Analysis as a Kernel Eigenvalue Problem." \url{https://www.mlpack.org/papers/kpca.pdf}.
}
\seealso{
\code{\link{predict_diagram_kpca}} for predicting embedding coordinates of new diagrams.
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
