% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_dim_dist.R
\name{vis_dim_dist}
\alias{vis_dim_dist}
\title{Visualize the distribution difference of samples after dimension reduction analysis}
\usage{
vis_dim_dist(
  ids = c("TP53", "KRAS", "PTEN", "MDM2", "CDKN1A"),
  data_type = "mRNA",
  group_info = NULL,
  DR_method = c("PCA", "UMAP", "tSNE"),
  palette = "Set1",
  add_margin = NULL,
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{ids}{molecular identifiers (>=3)}

\item{data_type}{molecular types, refer to query_pancan_value() function}

\item{group_info}{two-column grouping information with names 'Sample','Group'}

\item{DR_method}{the dimension reduction method}

\item{palette}{the color setting of RColorBrewer}

\item{add_margin}{the marginal plot (NULL, "density", "boxplot")}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\value{
a ggplot object or rawdata list
}
\description{
Visualize the distribution difference of samples after dimension reduction analysis
}
\examples{
\dontrun{
group_info = tcga_clinical_fine \%>\% 
  dplyr::filter(Cancer=="BRCA") \%>\% 
  dplyr::select(Sample, Code) \%>\% 
  dplyr::rename(Group=Code)

vis_dim_dist(
  ids = c("TP53", "KRAS", "PTEN", "MDM2", "CDKN1A"),
  group_info = group_info
)

}

}
