% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_relative.R
\name{filter_relative}
\alias{filter_relative}
\title{Filter the Observations Before or After a Condition is Fulfilled}
\usage{
filter_relative(
  dataset,
  by_vars,
  order,
  condition,
  mode,
  selection,
  inclusive,
  keep_no_ref_groups = TRUE,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} and \code{order} arguments are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

\describe{
\item{Default value}{none}
}}

\item{order}{Sort order

Within each by group the observations are ordered by the specified order.

For handling of \code{NA}s in sorting variables see \href{../articles/generic.html#sort_order}{Sort Order}.

\describe{
\item{Permitted values}{list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))}}
\item{Default value}{none}
}}

\item{condition}{Condition for Reference Observation

The specified condition determines the reference observation. The output
dataset contains all observations before or after (\code{selection} parameter)
the reference observation.

\describe{
\item{Default value}{none}
}}

\item{mode}{Selection mode (first or last)

If \code{"first"} is specified, for each by group the observations before or
after (\code{selection} parameter) the observation where the condition
(\code{condition} parameter) is fulfilled the \emph{first} time is included in the
output dataset. If \code{"last"} is specified, for each by group the
observations before or after (\code{selection} parameter) the observation where
the condition (\code{condition} parameter) is fulfilled the \emph{last} time is
included in the output dataset.

\describe{
\item{Permitted values}{\code{"first"}, \code{"last"}}
\item{Default value}{none}
}}

\item{selection}{Select observations before or after the reference observation?

\describe{
\item{Permitted values}{\code{"before"}, \code{"after"}}
\item{Default value}{none}
}}

\item{inclusive}{Include the reference observation?

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{none}
}}

\item{keep_no_ref_groups}{Should by groups without reference observation be kept?

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}}
\item{Default value}{\code{TRUE}}
}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

\describe{
\item{Permitted values}{\code{"none"}, \code{"warning"}, \code{"error"}}
\item{Default value}{\code{"warning"}}
}}
}
\value{
A dataset containing for each by group the observations before or
after the observation where the condition was fulfilled the first or last
time
}
\description{
Filters the observations before or after the observation where a specified
condition is fulfilled for each by group. For example, the function could be
called to select for each subject all observations before the first disease
progression.
}
\details{
For each by group ( \code{by_vars} parameter) the observations before or
after (\code{selection} parameter) the observations where the condition
(\code{condition} parameter) is fulfilled the first or last time (\code{order}
parameter and \code{mode} parameter) is included in the output dataset.
}
\examples{
library(tibble)

response <- tribble(
  ~USUBJID, ~AVISITN, ~AVALC,
  "1",      1,        "PR",
  "1",      2,        "CR",
  "1",      3,        "CR",
  "1",      4,        "SD",
  "1",      5,        "NE",
  "2",      1,        "SD",
  "2",      2,        "PD",
  "2",      3,        "PD",
  "3",      1,        "SD",
  "4",      1,        "SD",
  "4",      2,        "PR",
  "4",      3,        "PD",
  "4",      4,        "SD",
  "4",      5,        "PR"
)

# Select observations up to first PD for each patient
response \%>\%
  filter_relative(
    by_vars = exprs(USUBJID),
    order = exprs(AVISITN),
    condition = AVALC == "PD",
    mode = "first",
    selection = "before",
    inclusive = TRUE
  )

# Select observations after last CR, PR, or SD for each patient
response \%>\%
  filter_relative(
    by_vars = exprs(USUBJID),
    order = exprs(AVISITN),
    condition = AVALC \%in\% c("CR", "PR", "SD"),
    mode = "last",
    selection = "after",
    inclusive = FALSE
  )

# Select observations from first response to first PD
response \%>\%
  filter_relative(
    by_vars = exprs(USUBJID),
    order = exprs(AVISITN),
    condition = AVALC \%in\% c("CR", "PR"),
    mode = "first",
    selection = "after",
    inclusive = TRUE,
    keep_no_ref_groups = FALSE
  ) \%>\%
  filter_relative(
    by_vars = exprs(USUBJID),
    order = exprs(AVISITN),
    condition = AVALC == "PD",
    mode = "first",
    selection = "before",
    inclusive = TRUE
  )
}
\seealso{
Utilities for Filtering Observations: 
\code{\link{count_vals}()},
\code{\link{filter_exist}()},
\code{\link{filter_extreme}()},
\code{\link{filter_joined}()},
\code{\link{filter_not_exist}()},
\code{\link{max_cond}()},
\code{\link{min_cond}()}
}
\concept{utils_fil}
\keyword{utils_fil}
