% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{format_imputed_dtc}
\alias{format_imputed_dtc}
\title{Format Imputed Date/Datetime}
\usage{
format_imputed_dtc(imputed)
}
\arguments{
\item{imputed}{A list of imputed date/time components.

\describe{
\item{Default value}{none}
}}
}
\value{
A character vector of formatted date/datetime strings.
}
\description{
Formats imputed date/datetime components into a string representation.
}
\details{
The function formats the imputed components into \code{"YYYY-MM-DD"} for dates
and \code{"YYYY-MM-DDThh:mm:ss"} for datetimes. It replaces any string containing
\code{"x"} with \code{NA}.
}
\examples{
# Format imputed datetime components
imputed_datetime <- list(
  year = "2020", month = "01", day = "01",
  hour = "12", minute = "00", second = "00"
)
formatted_datetime <- admiral:::format_imputed_dtc(imputed_datetime)
print(formatted_datetime)

# Format imputed date components
imputed_date <- list(year = "2020", month = "01", day = "01")
formatted_date <- admiral:::format_imputed_dtc(imputed_date)
print(formatted_date)

# Handle imputed datetime with missing parts (contains 'x')
# Expected: NA because 'x' is an undefined component
imputed_partial_datetime <- list(
  year = "2020", month = "xx", day = "01",
  hour = "12", minute = "00", second = "00"
)
formatted_partial_datetime <- admiral:::format_imputed_dtc(imputed_partial_datetime)
print(formatted_partial_datetime)

# Handle imputed date with missing parts (contains 'x')
# Expected: NA because 'x' is an undefined component
imputed_partial_date <- list(year = "2020", month = "xx", day = "01")
formatted_partial_date <- admiral:::format_imputed_dtc(imputed_partial_date)
print(formatted_partial_date)

}
\keyword{internal}
