% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animation_expression.R
\name{animation_expression}
\alias{animation_expression}
\title{Animation Expression}
\usage{
animation_expression(
  bg,
  bg.axes,
  bg.misc,
  bg.opts,
  blur.size,
  cliques,
  color_covariate_function,
  coord,
  covariate,
  covariate.factors,
  covariate.interp,
  covariate.legend.loc,
  covariate.name,
  covariate.range,
  covariate.thresh,
  covariate.ticks,
  crawl.mu.color,
  crawl.plot.type,
  cur.time,
  date.col,
  delta.t,
  dev.opts,
  dimmed,
  ID_names,
  interpolation_type,
  interval,
  legend.loc,
  main,
  method,
  n.frames,
  network,
  network.interp,
  network.ring.trans,
  network.ring.wt,
  network.segment.trans,
  network.thresh,
  network.segment.wt,
  par.opts,
  paths,
  paths.interp,
  plot.date,
  pt.alpha,
  pt.cex,
  pt.colors,
  pt.wd,
  res,
  scale,
  simulation,
  simulation.iter,
  tail.alpha,
  tail.colors,
  tail.length,
  tail.wd,
  theme_map,
  time.grid,
  Time.name,
  uncertainty.level,
  uncertainty.type,
  whole.path,
  xlim,
  ylim,
  ...
)
}
\arguments{
\item{bg}{a list object for the ggmap background if background object is supplied}

\item{bg.axes}{logical: should animation place axis labels when using a background image (default is \code{TRUE}). If \code{RGoogleMaps} is used to produce background, labels will be "northing" and "easting". Otherwise, the strings given to \code{coord} will be used.}

\item{bg.misc}{Character string which will be executed as \code{R} code after generating the background, and before adding trajectories, etc.}

\item{bg.opts}{Options passed to \code{plot()} function call that makes background in each frame. For example, this could be used to specify blue ocean and gray landcover if \code{background} is a \code{SpatialPolygonsDataFrame} and \code{bg.opts = list(bg = "dodgerblue4", col = "gray", border = "gray")}.}

\item{blur.size}{a integer of the size for blur points; default is 8}

\item{cliques}{A list of colors for network projections}

\item{color_covariate_function}{a function to generate color for covariate interpolation}

\item{coord}{A character vector of length 2 giving the names of the longitude/easting and latitude/northing columns in the \code{paths} \code{data.frame} (in that order). This is required if \code{paths} is not a \code{SpatialPointsDataFrame}.}

\item{covariate}{The name of the column in \code{paths} that identifies the covariate to be mapped to a ring of color around each point.}

\item{covariate.factors}{factor levels for covariate interpolation}

\item{covariate.interp}{interpolation for covariate projections}

\item{covariate.legend.loc}{either the location of the covariate legend, or \code{NA} if no legend is desired}

\item{covariate.name}{name of covariate interpolation}

\item{covariate.range}{the range of covariate interpolation}

\item{covariate.thresh}{if changed from its default value of \code{NULL}, the interpolated value of the covariate will be binarized based on this numeric value.}

\item{covariate.ticks}{}

\item{crawl.mu.color}{color for the main predictions for crawl interpolation; default is black}

\item{crawl.plot.type}{a character string of what type of the plot you wish to generate when \code{interpolation_type = "crawl"}. Default is "point.tail" for points with tails; input "point" for point plot and input "blur" for blur point plot; input "blur.point" for blur point with tails}

\item{cur.time}{start time of animation}

\item{date.col}{default is \code{"black"}}

\item{delta.t}{The gap in time between each frame in the animation. Specify one of \code{delta.t} or \code{n.frames}. If both are specified, \code{delta.t} is used.}

\item{dev.opts}{Options passed to \code{png()} before creating each frame.}

\item{dimmed}{Numeric vector of individuals to "dim" in the animation. Order corresponds to the order of the ID.name variable, or order of paths list.}

\item{ID_names}{a list of names for each animal in the data}

\item{interpolation_type}{a character string of the type of interpolation. Default is "gam" for a generalized addictive model. Input "crawl" to interpolate using \code{crawl} package}

\item{interval}{Seconds per frame in animation. Default is 1/12 (or 12 frames per second).}

\item{legend.loc}{passed to first argument of \code{legend()} function. Default is \code{"topright"}. \code{NA} removes legend.}

\item{main}{Title for each frame. SOON: support for changing titles to allow for, say, dates.}

\item{method}{either \code{"html"} (default) or \code{"mp4"}. The latter requires the user has installed \code{ffmpeg} (see \code{?animation::saveVideo()}).}

\item{n.frames}{The number of frames used to animate the complete time domain of the data.}

\item{network}{Array of dimensions (# individuals, # individuals, \code{n.frames}) that gives a dyanmic network structure among the individuals.}

\item{network.interp}{interpolated network of dimension \code{(n.indiv, n.indiv, n.frames)}}

\item{network.ring.trans}{transparency of network segments (default is 1)}

\item{network.ring.wt}{thickness of network rings (default is 3)}

\item{network.segment.trans}{}

\item{network.thresh}{}

\item{network.segment.wt}{thickness of network segments (default is 3)}

\item{par.opts}{Options passed to \code{par()} before creating each frame.}

\item{paths}{A list of all paths from each animals stored in a \code{data.frame} or \code{SpatialPointsDataFrame} object.}

\item{paths.interp}{a path animation object that contains all predicted and simulated paths for all animals}

\item{plot.date}{Logical variable toggling date text at the time center of the animation.}

\item{pt.alpha}{alpha value for the points}

\item{pt.cex}{A numeric value giving the character expansion (size) of the points for each individual. Default is 1.}

\item{pt.colors}{A vector of colors to be used for each individual in the animation. Default values come from Color Brewer palettes. When a network is provided, this is ignored and individuals are all colored black. If \code{NA}, no plot colors are chosen to distinguish individuals. This can be useful when making animations involving a covariate. Consider also setting \code{legend.loc} to \code{NA} in this case.}

\item{pt.wd}{size of the points; default is 1}

\item{res}{Resolution of images in animation. Increase this for higher quality (and larger) images.}

\item{scale}{}

\item{simulation}{logical. Generate simulation predictions to have multiple projects for the animal paths}

\item{simulation.iter}{an integer of how many paths the crawl model will generate}

\item{tail.alpha}{alpha value for the tails}

\item{tail.colors}{default is "gray87". Can be single color or vector of colors.}

\item{tail.length}{Length of the tail trailing each individual.}

\item{tail.wd}{Thickness of tail trailing behind each individual. Default is 1.}

\item{theme_map}{plot theme for ggplot, default is NULL}

\item{time.grid}{A vector of time interval.}

\item{Time.name}{The name of the columns in \code{paths} gving the observation times. This column must be of class \code{POSIXt}, or numeric.}

\item{uncertainty.level}{value in (0, 1) corresponding to \code{level} at which to draw uncertainty ellipses. \code{NA} (default) results in no ellipses.}

\item{uncertainty.type}{State what type of uncertainty plot 1 is default for tails more than 1 is amount of predicted trajectories for each unique individual and blurs for blur plot}

\item{whole.path}{logical. If \code{TRUE} (default = \code{FALSE}), the complete interpolated trajectories will be plotted in the background of the animation. If \code{whole.path = TRUE}, consider also setting \code{tail.length = 0}.}

\item{xlim}{Boundaries for plotting. If left undefined, the range of the data will be used.}

\item{ylim}{Boundaries for plotting. If left undefined, the range of the data will be used.}

\item{...}{other arguments to be passed to \code{ani.options} to animation options such as the time interval between image frames.}
}
\value{
animation for different methods and different interpolation types
}
\description{
Animation Expression
}
\keyword{internal}
