% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology-results.R
\name{get_development_rst}
\alias{get_development_rst}
\alias{get_development_df}
\alias{get_development}
\title{Get the beetles development}
\usage{
get_development_rst(pheno, generation, dates = prop_dates(pheno))

get_development_df(
  pheno,
  stations = prop_stations(pheno),
  generation = prop_hatched_generations(pheno),
  dates = prop_dates(pheno)
)
}
\arguments{
\item{pheno}{A  phenology (see \code{\link[=phenology]{phenology()}})}

\item{generation}{Generation of interest. For sister broods, 0.5 should be added. \code{get_development_df()} allows
multiple generations here.}

\item{dates}{Select dates that should be present in the output.}

\item{stations}{Pass a character vector to choose stations assigned to \code{pheno} by
their names, or pass different stations. See \code{\link[=stations_create]{stations_create()}} for details.}
}
\value{
\itemize{
\item \code{get_development_rst()}: A multi-layer SpatRaster.
\item \code{get_development_df()}: A data frame which contains a field for
each generation  (\code{gen_1}, \code{gen_1.5}, \code{gen_2}, \code{gen_2.5}, ...) requested.
}
}
\description{
Get the beetles development of specific generations. A value of -1
implies that the generation is not present yet.
}
\examples{
\donttest{
# calculate station-based phenology
p <- phenology('phenips-clim', barrks_data('stations'), .quiet = TRUE)

# print the development data frame of station 'Freiburg'
df <- get_development_df(p, 'Freiburg')
df[,4:ncol(df)] <- round(df[,4:ncol(df)], 3) # round results
df
}
}
