% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/battingStats.R
\name{RC2002}
\alias{RC2002}
\title{Batting: Calculate Runs Created using the updated 2002 formula.}
\usage{
RC2002(dat = NULL)
}
\arguments{
\item{dat}{A data frame you would wish to calculate. The data frame must have the same column names found in
The \code{Lahman} package or the Chadwick Bureau GitHub repository.}
}
\description{
The "2002 Version" is an updated version of the "Technical Version" by Bill James.
The 2002 RC uses the same counting stats as the Technical Version but applies weights to many of the raw stats.
Required fields from the batting table are "AB", "H", "BB", "X2B", "X3B", "HR", "GIDP", "HBP", "SB", "CS",
"SF" and "SH," "SO", and "IBB."
}
\examples{

data("Batting2016")
head(Batting2016)

Batting2016$RC2002 <- RC2002(Batting2016)

}
\seealso{
Other Batting functions: \code{\link{BABIP}},
  \code{\link{BA}}, \code{\link{BBpct}},
  \code{\link{CTpct}}, \code{\link{HRpct}},
  \code{\link{ISO}}, \code{\link{Kpct}}, \code{\link{OBP}},
  \code{\link{OPS}}, \code{\link{PA}},
  \code{\link{RCbasic}}, \code{\link{RCtech}},
  \code{\link{SLG}}, \code{\link{TBs}},
  \code{\link{XBHpct}}, \code{\link{XBperH}},
  \code{\link{wOBA}}, \code{\link{wRAA}}, \code{\link{wRC}}
}
\keyword{RC2002}
\keyword{base}
\keyword{extra}
\keyword{hit}
\keyword{per}
