% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/quickSource.R
\name{quickSource}
\alias{quickSource}
\title{Quickly Creating BigML Sources}
\usage{
quickSource(data, name = deparse(substitute(data)),
  header = !is.null(names(data)), locale = "en-US",
  missing_tokens = c("NA"),
  quote = "\\"", trim = TRUE, flatten = TRUE, ...)
}
\arguments{
\item{data}{A matrix or data frame containing data to upload to bigml.}

\item{name}{A string giving the name of the source.}

\item{header}{A logical value indicating whether to use the first row
of data as a header row.}

\item{locale}{A string indicating the desired locale.}

\item{missing_tokens}{A vector listing strings that should be treated as
missing.}

\item{quote}{A string giving the quote character to use.}

\item{trim}{A logical value indicating whether to trim white space.}

\item{flatten}{A logical value indicating whether to flatten the response
into a data frame.}

\item{\dots}{Arbitrary named arguments that are passed on to
\code{\link{formEncodeURL}} in order to create form-encoded URL options.}
}
\value{
\item{category}{numeric}
	\item{code}{numeric}
	\item{content_type}{character}
	\item{created}{character}
	\item{credits}{numeric}
	\item{description}{character}
	\item{fields}{data.frame (or list if flatten=FALSE)}
	\item{file_name}{character}
	\item{md5}{character}
	\item{name}{character}
	\item{number_of_datasets}{numeric}
	\item{number_of_models}{numeric}
	\item{number_of_predictions}{numeric}
	\item{private}{logical}
	\item{resource}{character}
	\item{size}{numeric}
	\item{source_parser}{list}
	\item{status}{list}
	\item{tags}{AsIs}
	\item{type}{numeric}
	\item{updated}{character}
}
\description{
Quickly Creating BigML Sources
}
\details{
quickSource will take its "data" dataframe argument and attempt
	to create an equivalent BigML source.  It does this by converting the
	dataframe to a csv file, compressing it, and uploading it directly to
	BigML.  Generally, it's better to use \code{\link{quickDataset}}, since
	this method attempts to preserve any type information in the data frame.
}
\note{
It is not currently possible to retrieve the original file from
	BigML, but it is possible to delete it.
}
\author{
Leon Hwang \email{hwang@bigml.com}
}
\references{
\url{https://bigml.com/developers/sources}
}
\seealso{
Other quick methods: \code{\link{quickDataset}};
  \code{\link{quickModel}}; \code{\link{quickPrediction}}

Other source methods: \code{\link{createSource}};
  \code{\link{getSource}}; \code{\link{listSources}}
}

