% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{breakfast}
\alias{breakfast}
\title{Methods for fast multiple change-point detection and estimation}
\usage{
breakfast(
  x,
  sd.fn = NULL,
  option = c("suggested", "user", "all")[1],
  solution.path = list(name = "idetect", args = list()),
  model.selection = list(name = "ic", args = list())
)
}
\arguments{
\item{x}{A numeric vector containing the data to be processed}

\item{sd.fn}{Either a positive numeric constant containing the square root of the error variance, 
or a function for generating this quantity that takes \code{x} as an input; if \code{sd.fn = NULL}, 
a mean absolute deviation estimator is generated internally.}

\item{option}{A string specifying the option for selecting the combination of
solution path and model selection procedures. 
The default choice is \code{option = "suggested"} with combinations of solution path and model selection methods
suggested for their good properties.
\itemize{
\item{"suggested"}{ Suggested combinations based on their performance, which are \code{("wbs2", "sdll")}, \code{("idetect", "ic")}, \code{("idetect_seq", "thresh")} and \code{("tguh", "lp")}}
\item{"user"}{ User-specified combination (to be supplied by \code{solution.path} and \code{model.selection}) }
\item{"all"}{ All currently supported combinations; we exclude the following combinations of the solution path and model selection methods based on their performance:  \code{("not", "sdll")}, \code{("idetect", "thresh")}, \code{("idetect", "lp")}, \code{("idetect_seq", "ic")}, \code{("idetect_seq", "lp")}, \code{("idetect_seq", "sdll")} }
}}

\item{solution.path}{A list containing the name of a solution path generating method
and any arguments to be used with them; currently supported methods are
\itemize{
\item{"idetect"}{ IDetect, see \link[breakfast]{sol.idetect}} 
\item{"idetect_seq"}{ Sequential IDetect, see \link[breakfast]{sol.idetect_seq}} 
\item{"not"}{ Narrowest-Over-Threshold, see \link[breakfast]{sol.not}}
\item{"tguh"}{ Tail-Greedy Unbalanced Haar, see \link[breakfast]{sol.tguh}}
\item{"wbs"}{ Wild Binary Segmentation, see \link[breakfast]{sol.wbs}}
\item{"wbs2"}{ Wild Binary Segmentation 2, see \link[breakfast]{sol.wbs2}}
}}

\item{model.selection}{A list of containing the name of a model selection method
and any arguments to be used with them; currently supported methods are
\itemize{
\item{"ic"}{ Strengthened Schwarz information criterion, see \link[breakfast]{model.ic}}
\item{"lp"}{ Localised pruning, see \link[breakfast]{model.lp}}
\item{"sdll"}{ Steepest Drop to Low Levels method, see \link[breakfast]{model.sdll}}
\item{"thresh"}{ Thresholding, see \link[breakfast]{model.thresh}}
}}
}
\value{
An S3 object of class \code{breakfast.cpts}, which contains the following fields:
\itemize{
\item{x}{ Input vector \code{x}}
\item{cptmodel.list}{ A list containing S3 objects of class \code{cptmodel}; each contains the following fields:}
\itemize{
  \item{solution.path}{ The solution path method used}
  \item{model}{ The model selection method used to return the final change-point estimators object}
  \item{no.of.cpt}{ The number of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}}
  \item{cpts}{ The locations of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}. These are the end-points of the corresponding constant-mean intervals}
  \item{est}{ An estimate of the piecewise-constant mean of the vector \code{cptpath.object$x}; the values are the sample means of the data (replicated a suitable number of times) between each pair of consecutive detected change-points}
  }
}
}
\description{
This function estimates the number and locations of change-points in a data sequence,
which is modelled as a piecewise-constant function plus i.i.d. Gaussian noise. 
This is carried out via a two-stage procedure combining solution path generation and model selection methodologies.
}
\details{
Please also take a look at the vignette for tips/suggestions/examples of using the breakfast package.
}
\examples{
f <- rep(rep(c(0, 1), each = 50), 10)
x <- f + rnorm(length(f))
breakfast(x, option = 'suggested')
}
\references{
A. Anastasiou & P. Fryzlewicz (2019). Detecting multiple generalized change-points by isolating single ones. \emph{arXiv preprint arXiv:1901.10852}.

R. Baranowski, Y. Chen & P. Fryzlewicz (2019). Narrowest-over-threshold detection of multiple change points and change-point-like features. \emph{Journal of the Royal Statistical Society: Series B}, 81(3), 649--672.

H. Cho & C. Kirch (2020) Two-stage data segmentation permitting multiscale change points, heavy tails and dependence. \emph{arXiv preprint arXiv:1910.12486}.

P. Fryzlewicz (2014). Wild binary segmentation for multiple change-point detection. \emph{The Annals of Statistics}, 42(6), 2243--2281.

P. Fryzlewicz (2020). Detecting possibly frequent change-points: Wild Binary Segmentation 2 and steepest-drop model selection. \emph{To appear in Journal of the Korean Statistical Society}.

P. Fryzlewicz (2018). Tail-greedy bottom-up data decompositions and fast multiple change-point detection. \emph{The Annals of Statistics}, 46(6B), 3390--3421.
}
