% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.R
\name{model.ic}
\alias{model.ic}
\title{Estimating change-points in the piecewise-constant mean of a noisy data sequence via the strengthened Schwarz information criterion}
\usage{
model.ic(cptpath.object, alpha = 1.01, q.max = NULL)
}
\arguments{
\item{cptpath.object}{A solution-path object, returned by a \code{sol.[name]} routine. Note that the field \code{cptpath.object$x} contains the input data sequence.}

\item{alpha}{The parameter associated with the sSIC. The default value is 1.01. Note that the SIC is recovered when alpha = 1.}

\item{q.max}{The maximum number of change-points allowed. If nothing or \code{NULL} is provided, the default value of around \code{min(25, n/log(n))} will be used.}
}
\value{
An S3 object of class \code{cptmodel}, which contains the following fields: 
\item{solution.path}{The solution path method used to obtain \code{cptpath.object}}
\item{model}{The model selection method used to return the final change-point estimators object, here its value is \code{"ic"}}
\item{no.of.cpt}{The number of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}}
\item{cpts}{The locations of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}. These are the end-points of the corresponding constant-mean intervals}
\item{est}{An estimate of the piecewise-constant mean of the vector \code{cptpath.object$x}; the values are the sample means of the data (replicated a suitable number of times) between each pair of consecutive detected change-points}
}
\description{
This function estimates the number and locations of change-points in the piecewise-constant mean of a noisy data sequence via the sSIC (strengthened Schwarz information criterion) method.
}
\details{
The model selection method for algorithms that produce nested solution path is described in 
"Wild binary segmentation for multiple change-point detection", P. Fryzlewicz (2014), The Annals of Statitics, 42: 2243--2281.
The corresponding description for those that produce non-nested solution set can be found in 
"Narrowest-over-threshold detection of multiple change points and change-point-like features", R. Baranowski, Y. Chen and P. Fryzlewicz (2019), Journal of Royal Statistical Society: Series B, 81(3), 649--672.
}
\examples{
x <- c(rep(0, 100), rep(1, 100), rep(0, 100)) + rnorm(300)
model.ic(sol.wbs(x))
model.ic(sol.not(x))
}
\references{
P. Fryzlewicz (2014). Wild binary segmentation for multiple change-point detection. \emph{The Annals of Statistics}, 42(6), 2243--2281.

R. Baranowski, Y. Chen & P. Fryzlewicz (2019). Narrowest-over-threshold detection of multiple change points and change-point-like features. \emph{Journal of the Royal Statistical Society: Series B}, 81(3), 649--672.
}
\seealso{
\code{\link{sol.idetect}}, \code{\link{sol.not}}, \code{\link{sol.tguh}}, \code{\link{sol.wbs}}, \code{\link{sol.wbs2}}, \code{\link{breakfast}}
}
