% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{bs4TabCard}
\alias{bs4TabCard}
\title{Create a Boostrap 4 tabCard}
\usage{
bs4TabCard(..., title = NULL, width = 6, height = NULL,
  elevation = NULL)
}
\arguments{
\item{...}{Contents of the box: should be bs4TabPanel.}

\item{title}{TabCard title.}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default valueBox width of 4 occupies 1/3 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{height}{The height of a box, in pixels or other CSS unit. By default
the height scales automatically with the content.}

\item{elevation}{tabCard elevation.}
}
\description{
Build an adminLTE3 card with tabs
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shiny::shinyApp(
   ui = bs4DashPage(
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(),
    controlbar = bs4DashControlbar(),
    footer = bs4DashFooter(),
    title = "test",
    body = bs4DashBody(
     bs4TabCard(
      title = "A card with tabs",
      bs4TabPanel(
       tabName = "Tab1", 
       active = FALSE,
       "Content 1"
      ),
      bs4TabPanel(
       tabName = "Tab2", 
       active = TRUE,
       "Content 2"
      ),
      bs4TabPanel(
       tabName = "Tab3", 
       active = FALSE,
       "Content 3"
      )
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\seealso{
Other cards: \code{\link{bs4Card}},
  \code{\link{bs4InfoBox}}, \code{\link{bs4ValueBox}}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
