% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Callout}
\alias{bs4Callout}
\title{Create a Bootstrap 4 callout}
\usage{
bs4Callout(
  ...,
  title,
  width = 6,
  elevation = NULL,
  status = c("primary", "warning", "danger", "info", "success")
)
}
\arguments{
\item{...}{Callout content.}

\item{title}{Callout title.}

\item{width}{Callout width. Between 1 and 12.}

\item{elevation}{Callout elevation.}

\item{status}{Callout status. "primary", "success", "warning", "danger" or "info".}
}
\description{
AdminLTE3 callout
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
       title = "Callouts",
       bs4Callout(
        title = "I am a danger callout!",
        elevation = 4,
        status = "danger",
        "There is a problem that we need to fix. 
        A wonderful serenity has taken possession of 
        my entire soul, like these sweet mornings of 
        spring which I enjoy with my whole heart."
       ),
       bs4Callout(
        title = "I am a danger callout!",
        status = "warning",
        "This is a yellow callout."
       )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
